/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.search.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderHelper;
import org.hibernate.search.util.FileHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSMasterDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static final String CURRENT1 = "current1";
    private static final String CURRENT2 = "current2";
    private static final String[] CURRENT_DIR_NAME = new String[]{null, "current1", "current2"};
    private static final Logger log = LoggerFactory.make();
    private final Timer timer = new Timer(true);
    private volatile int current;
    private FSDirectory directory;
    private String indexName;
    private BuildContext context;
    private long copyChunkSize;
    private File sourceDir;
    private File indexDir;
    private String directoryProviderName;
    private Properties properties;
    private TriggerTask task;
    private Lock directoryProviderLock;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.properties = properties;
        this.directoryProviderName = directoryProviderName;
        this.sourceDir = DirectoryProviderHelper.getSourceDirectory(directoryProviderName, properties, true);
        log.debug("Source directory: {}", (Object)this.sourceDir.getPath());
        this.indexDir = DirectoryProviderHelper.getVerifiedIndexDir(directoryProviderName, properties, true);
        log.debug("Index directory: {}", (Object)this.indexDir.getPath());
        try {
            this.indexName = this.indexDir.getCanonicalPath();
            this.directory = DirectoryProviderHelper.createFSIndex(this.indexDir, properties);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
        this.copyChunkSize = DirectoryProviderHelper.getCopyBufferSize(directoryProviderName, properties);
        this.context = context;
        this.current = 0;
    }

    @Override
    public void start() {
        int currentLocal = 0;
        this.directoryProviderLock = this.context.getDirectoryProviderLock(this);
        this.context = null;
        try {
            if (new File(this.sourceDir, CURRENT1).exists()) {
                currentLocal = 2;
            } else if (new File(this.sourceDir, CURRENT2).exists()) {
                currentLocal = 1;
            } else {
                log.debug("Source directory for '{}' will be initialized", (Object)this.indexName);
                currentLocal = 1;
            }
            String currentString = Integer.valueOf(currentLocal).toString();
            File subDir = new File(this.sourceDir, currentString);
            FileHelper.synchronize(this.indexDir, subDir, true, this.copyChunkSize);
            new File(this.sourceDir, CURRENT1).delete();
            new File(this.sourceDir, CURRENT2).delete();
            new File(this.sourceDir, CURRENT_DIR_NAME[currentLocal]).createNewFile();
            log.debug("Current directory: {}", (Object)currentLocal);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + this.directoryProviderName, e);
        }
        this.task = new TriggerTask(this.indexDir, this.sourceDir);
        long period = DirectoryProviderHelper.getRefreshPeriod(this.properties, this.directoryProviderName);
        this.timer.scheduleAtFixedRate((TimerTask)this.task, period, period);
        this.current = currentLocal;
    }

    @Override
    public FSDirectory getDirectory() {
        int readCurrentState = this.current;
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSMasterDirectoryProvider)) {
            return false;
        }
        FSMasterDirectoryProvider other = (FSMasterDirectoryProvider)obj;
        int readCurrentState = other.current;
        readCurrentState = this.current;
        return this.indexName.equals(other.indexName);
    }

    public int hashCode() {
        int readCurrentState = this.current;
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }

    @Override
    public void stop() {
        int readCurrentState = this.current;
        this.timer.cancel();
        this.task.stop();
        try {
            this.directory.close();
        }
        catch (Exception e) {
            log.error("Unable to properly close Lucene directory {}" + this.directory.getFile(), (Throwable)e);
        }
    }

    private class CopyDirectory
    implements Runnable {
        private final File source;
        private final File destination;
        private final AtomicBoolean inProgress = new AtomicBoolean(false);

        public CopyDirectory(File source, File destination) {
            this.source = source;
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FSMasterDirectoryProvider.this.directoryProviderLock.lock();
            try {
                long start = System.nanoTime();
                int oldIndex = FSMasterDirectoryProvider.this.current;
                int index = oldIndex == 1 ? 2 : 1;
                File destinationFile = new File(this.destination, Integer.valueOf(index).toString());
                try {
                    log.trace("Copying {} into {}", (Object)this.source, (Object)destinationFile);
                    FileHelper.synchronize(this.source, destinationFile, true, FSMasterDirectoryProvider.this.copyChunkSize);
                    FSMasterDirectoryProvider.this.current = index;
                }
                catch (IOException e) {
                    log.error("Unable to synchronize source of " + FSMasterDirectoryProvider.this.indexName, (Throwable)e);
                    FSMasterDirectoryProvider.this.directoryProviderLock.unlock();
                    this.inProgress.set(false);
                    return;
                }
                if (!new File(this.destination, CURRENT_DIR_NAME[oldIndex]).delete()) {
                    log.warn("Unable to remove previous marker file from source of {}", (Object)FSMasterDirectoryProvider.this.indexName);
                }
                try {
                    new File(this.destination, CURRENT_DIR_NAME[index]).createNewFile();
                }
                catch (IOException e) {
                    log.warn("Unable to create current marker in source of " + FSMasterDirectoryProvider.this.indexName, (Throwable)e);
                }
                log.trace("Copy for {} took {} ms", (Object)FSMasterDirectoryProvider.this.indexName, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            }
            finally {
                FSMasterDirectoryProvider.this.directoryProviderLock.unlock();
                this.inProgress.set(false);
            }
        }
    }

    private class TriggerTask
    extends TimerTask {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private final CopyDirectory copyTask;

        public TriggerTask(File source, File destination) {
            this.copyTask = new CopyDirectory(source, destination);
        }

        public void run() {
            if (this.copyTask.inProgress.compareAndSet(false, true)) {
                this.executor.execute(this.copyTask);
            } else {
                log.info("Skipping directory synchronization, previous work still in progress: {}", (Object)FSMasterDirectoryProvider.this.indexName);
            }
        }

        public void stop() {
            this.executor.shutdownNow();
        }
    }
}

