/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdatableBackendQueueProcessorFactory;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.XMLHelper;
import org.hibernate.util.ConfigHelper;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JGroupsBackendQueueProcessorFactory
implements UpdatableBackendQueueProcessorFactory {
    private static final Logger log = LoggerFactory.make();
    public static final String JGROUPS_PREFIX = "hibernate.search.worker.backend.jgroups.";
    public static final String CONFIGURATION_STRING = "hibernate.search.worker.backend.jgroups.configurationString";
    public static final String CONFIGURATION_XML = "hibernate.search.worker.backend.jgroups.configurationXml";
    public static final String CONFIGURATION_FILE = "hibernate.search.worker.backend.jgroups.configurationFile";
    private static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "flush-udp.xml";
    public static final String JG_CLUSTER_NAME = "hibernate.search.worker.backend.jgroups.clusterName";
    protected String clusterName = "HSearchCluster";
    protected SearchFactoryImplementor searchFactory;
    protected Channel channel = null;
    protected Address address;

    @Override
    public void initialize(Properties props, WorkerBuildContext context) {
        this.searchFactory = context.getUninitializedSearchFactory();
        if (props.containsKey(JG_CLUSTER_NAME)) {
            this.setClusterName(props.getProperty(JG_CLUSTER_NAME));
        }
        this.prepareJGroupsChannel(props);
    }

    @Override
    public void updateDirectoryProviders(Set<DirectoryProvider<?>> providers, WorkerBuildContext context) {
    }

    private void prepareJGroupsChannel(Properties props) {
        log.info("Starting JGroups Channel");
        try {
            this.buildChannel(props);
            this.channel.setOpt(5, (Object)Boolean.TRUE);
            this.channel.connect(this.clusterName);
        }
        catch (ChannelException e) {
            throw new SearchException("Unable to connect to: [" + this.clusterName + "] JGroups channel");
        }
        log.info("Connected to cluster [ {} ]. The node address is {}", (Object)this.clusterName, (Object)this.getAddress());
        if (!this.channel.flushSupported()) {
            log.warn("FLUSH is not present in your JGroups stack!  FLUSH is needed to ensure messages are not dropped while new nodes join the cluster.  Will proceed, but inconsistencies may arise!");
        }
    }

    private void buildChannel(Properties props) {
        if (props != null) {
            String cfg;
            if (props.containsKey(CONFIGURATION_FILE)) {
                cfg = props.getProperty(CONFIGURATION_FILE);
                try {
                    this.channel = new JChannel(ConfigHelper.locateConfig((String)cfg));
                }
                catch (Exception e) {
                    log.error("Error while trying to create a channel using config files: {}", (Object)cfg);
                    throw new SearchException(e);
                }
            }
            if (props.containsKey(CONFIGURATION_XML)) {
                cfg = props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel(XMLHelper.elementFromString(cfg));
                }
                catch (Exception e) {
                    log.error("Error while trying to create a channel using config XML: {}", (Object)cfg);
                    throw new SearchException(e);
                }
            }
            if (props.containsKey(CONFIGURATION_STRING)) {
                cfg = props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel(cfg);
                }
                catch (Exception e) {
                    log.error("Error while trying to create a channel using config string: {}", (Object)cfg);
                    throw new SearchException(e);
                }
            }
        }
        if (this.channel == null) {
            log.info("Unable to use any JGroups configuration mechanisms provided in properties {}. Using default JGroups configuration file!", (Object)props);
            try {
                URL fileUrl = ConfigHelper.locateConfig((String)DEFAULT_JGROUPS_CONFIGURATION_FILE);
                if (fileUrl != null) {
                    this.channel = new JChannel(fileUrl);
                } else {
                    log.warn("Default JGroups configuration file was not found. Attempt to start JGroups channel with default configuration!");
                    this.channel = new JChannel();
                }
            }
            catch (ChannelException e) {
                throw new SearchException("Unable to start JGroups channel", e);
            }
        }
    }

    @Override
    public abstract Runnable getProcessor(List<LuceneWork> var1);

    @Override
    public void close() {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                log.info("Disconnecting and closing JGroups Channel");
                this.channel.disconnect();
                this.channel.close();
            }
        }
        catch (Exception toLog) {
            log.error("Problem closing channel; setting it to null", (Throwable)toLog);
            this.channel = null;
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Address getAddress() {
        if (this.address == null && this.channel != null) {
            this.address = this.channel.getLocalAddress();
        }
        return this.address;
    }
}

