/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.event.FullTextIndexEventListener;

public abstract class ContextHelper {
    public static SearchFactoryImplementor getSearchFactory(Session session) {
        return ContextHelper.getSearchFactoryBySFI((SessionImplementor)session);
    }

    public static SearchFactoryImplementor getSearchFactoryBySFI(SessionImplementor session) {
        PostInsertEventListener[] listeners = session.getListeners().getPostInsertEventListeners();
        FullTextIndexEventListener listener = null;
        for (PostInsertEventListener candidate : listeners) {
            if (!(candidate instanceof FullTextIndexEventListener)) continue;
            listener = (FullTextIndexEventListener)candidate;
            break;
        }
        if (listener == null) {
            throw new HibernateException("Hibernate Search Event listeners not configured, please check the reference documentation and the application's hibernate.cfg.xml");
        }
        return listener.getSearchFactoryImplementor();
    }
}

