/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.DefaultBoostStrategy;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.LuceneOptionsImpl;
import org.hibernate.search.engine.WorkPlan;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.util.ClassLoaderHelper;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.PassThroughAnalyzer;
import org.hibernate.search.util.ReflectionHelper;
import org.hibernate.search.util.ScopedAnalyzer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentBuilder<T>
implements DocumentBuilder {
    private static final Logger log = LoggerFactory.make();
    private final XClass beanXClass;
    protected final String beanXClassName;
    protected final Class<?> beanClass;
    private Set<Class<?>> mappedSubclasses = new HashSet();
    private int level = 0;
    private int maxLevel = Integer.MAX_VALUE;
    private final ScopedAnalyzer analyzer = new ScopedAnalyzer();
    private Similarity similarity;
    private boolean isRoot;
    private Analyzer passThroughAnalyzer = new PassThroughAnalyzer();
    protected final Set<String> indexedEmbeddedCollectionRoles = new TreeSet<String>();
    protected final Set<String> containedInCollectionRoles = new TreeSet<String>();
    protected final PropertiesMetadata metadata = new PropertiesMetadata();
    protected EntityState entityState;
    protected ReflectionManager reflectionManager;
    private boolean stateInspectionOptimizationsEnabled = true;

    public AbstractDocumentBuilder(XClass xClass, ConfigContext context, Similarity similarity, ReflectionManager reflectionManager, Set<XClass> optimizationBlackList) {
        if (xClass == null) {
            throw new AssertionFailure("Unable to build a DocumentBuilderContainedEntity with a null class");
        }
        this.entityState = EntityState.CONTAINED_IN_ONLY;
        this.beanXClass = xClass;
        this.beanXClassName = xClass.getName();
        this.reflectionManager = reflectionManager;
        this.beanClass = reflectionManager.toClass(xClass);
        this.similarity = similarity;
        this.metadata.boost = this.getBoost(xClass);
        this.metadata.classBoostStrategy = this.getDynamicBoost(xClass);
        this.metadata.analyzer = context.getDefaultAnalyzer();
        HashSet<XClass> processedClasses = new HashSet<XClass>();
        processedClasses.add(xClass);
        this.initializeClass(xClass, this.metadata, true, "", processedClasses, context, optimizationBlackList, false);
        this.analyzer.setGlobalAnalyzer(this.metadata.analyzer);
        if (this.similarity == null) {
            this.similarity = context.getDefaultSimilarity();
        }
    }

    public abstract void addWorkToQueue(Class<T> var1, T var2, Serializable var3, boolean var4, boolean var5, boolean var6, List<LuceneWork> var7);

    protected abstract void documentBuilderSpecificChecks(XProperty var1, PropertiesMetadata var2, boolean var3, String var4, ConfigContext var5);

    public abstract Serializable getId(Object var1);

    public boolean isRoot() {
        return this.isRoot;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public XClass getBeanXClass() {
        return this.beanXClass;
    }

    public PropertiesMetadata getMetadata() {
        return this.metadata;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public EntityState getEntityState() {
        return this.entityState;
    }

    public Set<Class<?>> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    public void postInitialize(Set<Class<?>> indexedClasses) {
        Class<?> plainClass = this.beanClass;
        if (this.entityState == EntityState.NON_INDEXABLE) {
            throw new AssertionFailure("A non indexed entity is post processed");
        }
        HashSet tempMappedSubclasses = new HashSet();
        for (Class<?> currentClass : indexedClasses) {
            if (plainClass == currentClass || !plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
        this.isRoot = true;
        for (Class<?> superClass = plainClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!indexedClasses.contains(superClass)) continue;
            this.isRoot = false;
            break;
        }
        this.reflectionManager = null;
    }

    protected Analyzer getAnalyzer(XAnnotatedElement annotatedElement, ConfigContext context) {
        org.hibernate.search.annotations.Analyzer analyzerAnn = (org.hibernate.search.annotations.Analyzer)annotatedElement.getAnnotation(org.hibernate.search.annotations.Analyzer.class);
        return this.getAnalyzer(analyzerAnn, context);
    }

    protected void addToScopedAnalyzer(String fieldName, Analyzer analyzer, Index index) {
        if (index == Index.TOKENIZED) {
            if (analyzer != null) {
                this.analyzer.addScopedAnalyzer(fieldName, analyzer);
            }
        } else {
            this.analyzer.addScopedAnalyzer(fieldName, this.passThroughAnalyzer);
        }
    }

    protected Float getBoost(XProperty member, Field fieldAnn) {
        float computedBoost = 1.0f;
        Boost boostAnn = (Boost)member.getAnnotation(Boost.class);
        if (boostAnn != null) {
            computedBoost = boostAnn.value();
        }
        if (fieldAnn != null) {
            computedBoost *= fieldAnn.boost().value();
        }
        return Float.valueOf(computedBoost);
    }

    protected BoostStrategy getDynamicBoost(XProperty member) {
        BoostStrategy strategy;
        DynamicBoost boostAnnotation = (DynamicBoost)member.getAnnotation(DynamicBoost.class);
        if (boostAnnotation == null) {
            return new DefaultBoostStrategy();
        }
        Class<? extends BoostStrategy> boostStrategyClass = boostAnnotation.impl();
        try {
            strategy = boostStrategyClass.newInstance();
        }
        catch (Exception e) {
            throw new SearchException("Unable to instantiate boost strategy implementation: " + boostStrategyClass.getName());
        }
        return strategy;
    }

    protected Field.TermVector getTermVector(TermVector vector) {
        switch (vector) {
            case NO: {
                return Field.TermVector.NO;
            }
            case YES: {
                return Field.TermVector.YES;
            }
            case WITH_OFFSETS: {
                return Field.TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return Field.TermVector.WITH_POSITIONS;
            }
            case WITH_POSITION_OFFSETS: {
                return Field.TermVector.WITH_POSITIONS_OFFSETS;
            }
        }
        throw new AssertionFailure("Unexpected TermVector: " + (Object)((Object)vector));
    }

    protected Field.Index getIndex(Index index) {
        switch (index) {
            case NO: {
                return Field.Index.NO;
            }
            case NO_NORMS: {
                return Field.Index.NOT_ANALYZED_NO_NORMS;
            }
            case TOKENIZED: {
                return Field.Index.ANALYZED;
            }
            case UN_TOKENIZED: {
                return Field.Index.NOT_ANALYZED;
            }
        }
        throw new AssertionFailure("Unexpected Index: " + (Object)((Object)index));
    }

    public void appendContainedInWorkForInstance(Object instance, WorkPlan workplan) {
        for (int i = 0; i < this.metadata.containedInGetters.size(); ++i) {
            XMember member = this.metadata.containedInGetters.get(i);
            Object value = ReflectionHelper.getMemberValue(instance, member);
            if (value == null) continue;
            if (member.isArray()) {
                Object[] array;
                for (Object arrayValue : array = (Object[])value) {
                    this.processSingleContainedInInstance(workplan, arrayValue);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection<T> collection;
                block7: {
                    collection = null;
                    try {
                        collection = this.getActualCollection(member, value);
                        collection.size();
                    }
                    catch (Exception e) {
                        if (!e.getClass().getName().contains("org.hibernate.LazyInitializationException")) break block7;
                        collection = null;
                    }
                }
                if (collection == null) continue;
                for (T collectionValue : collection) {
                    this.processSingleContainedInInstance(workplan, collectionValue);
                }
                continue;
            }
            this.processSingleContainedInInstance(workplan, value);
        }
    }

    private void initializeClass(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, ConfigContext context, Set<XClass> optimizationBlackList, boolean disableOptimizationsArg) {
        LinkedList<XClass> hierarchy = new LinkedList<XClass>();
        XClass next = null;
        XClass previousClass = clazz;
        while (previousClass != null) {
            next = previousClass.getSuperclass();
            if (next != null) {
                hierarchy.add(0, previousClass);
            }
            previousClass = next;
        }
        for (XClass currentClass : hierarchy) {
            this.initializeClassLevelAnnotations(currentClass, propertiesMetadata, isRoot, prefix, context);
        }
        boolean disableOptimizations = disableOptimizationsArg || !this.stateInspectionOptimizationsEnabled();
        for (XClass currentClass : hierarchy) {
            List methods = currentClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMemberLevelAnnotations(currentClass, method, propertiesMetadata, isRoot, prefix, processedClasses, context, optimizationBlackList, disableOptimizations);
            }
            List fields = currentClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMemberLevelAnnotations(currentClass, field, propertiesMetadata, isRoot, prefix, processedClasses, context, optimizationBlackList, disableOptimizations);
            }
        }
    }

    private void initializeClassLevelAnnotations(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, ConfigContext context) {
        ClassBridge classBridgeAnn;
        Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)clazz, context);
        if (analyzer != null) {
            propertiesMetadata.analyzer = analyzer;
        }
        this.checkForAnalyzerDefs((XAnnotatedElement)clazz, context);
        ClassBridges classBridgesAnn = (ClassBridges)clazz.getAnnotation(ClassBridges.class);
        if (classBridgesAnn != null) {
            ClassBridge[] classBridges;
            for (ClassBridge cb : classBridges = classBridgesAnn.value()) {
                this.bindClassBridgeAnnotation(prefix, propertiesMetadata, cb, clazz, context);
            }
        }
        if ((classBridgeAnn = (ClassBridge)clazz.getAnnotation(ClassBridge.class)) != null) {
            this.bindClassBridgeAnnotation(prefix, propertiesMetadata, classBridgeAnn, clazz, context);
        }
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)clazz, propertiesMetadata);
        if (isRoot) {
            this.checkForSimilarity(clazz);
        }
    }

    private void initializeMemberLevelAnnotations(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, ConfigContext context, Set<XClass> optimizationBlackList, boolean disableOptimizations) {
        this.checkForField(member, propertiesMetadata, prefix, context);
        this.checkForFields(member, propertiesMetadata, prefix, context);
        this.checkForAnalyzerDefs((XAnnotatedElement)member, context);
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)member, propertiesMetadata);
        this.checkForIndexedEmbedded(classHostingMember, member, propertiesMetadata, prefix, processedClasses, context, optimizationBlackList, disableOptimizations);
        this.checkForContainedIn(classHostingMember, member, propertiesMetadata);
        this.documentBuilderSpecificChecks(member, propertiesMetadata, isRoot, prefix, context);
    }

    private Analyzer getAnalyzer(org.hibernate.search.annotations.Analyzer analyzerAnn, ConfigContext context) {
        Class<Void> analyzerClass;
        Class<Void> clazz = analyzerClass = analyzerAnn == null ? Void.TYPE : analyzerAnn.impl();
        if (analyzerClass == Void.TYPE) {
            String definition;
            String string = definition = analyzerAnn == null ? "" : analyzerAnn.definition();
            if (StringHelper.isEmpty((String)definition)) {
                return null;
            }
            return context.buildLazyAnalyzer(definition);
        }
        try {
            return ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, context.getLuceneMatchVersion());
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not extend " + Analyzer.class.getName() + ": " + analyzerClass.getName(), e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClass.getName(), e);
        }
    }

    private void checkForAnalyzerDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        AnalyzerDefs defs = (AnalyzerDefs)annotatedElement.getAnnotation(AnalyzerDefs.class);
        if (defs != null) {
            for (AnalyzerDef def : defs.value()) {
                context.addAnalyzerDef(def, annotatedElement);
            }
        }
        AnalyzerDef def = (AnalyzerDef)annotatedElement.getAnnotation(AnalyzerDef.class);
        context.addAnalyzerDef(def, annotatedElement);
    }

    private void checkForAnalyzerDiscriminator(XAnnotatedElement annotatedElement, PropertiesMetadata propertiesMetadata) {
        AnalyzerDiscriminator discriminatorAnn = (AnalyzerDiscriminator)annotatedElement.getAnnotation(AnalyzerDiscriminator.class);
        if (discriminatorAnn != null) {
            if (propertiesMetadata.discriminator != null) {
                throw new SearchException("Multiple AnalyzerDiscriminator defined in the same class hierarchy: " + this.beanXClass.getName());
            }
            Class<? extends Discriminator> discriminatorClass = discriminatorAnn.impl();
            try {
                propertiesMetadata.discriminator = discriminatorClass.newInstance();
            }
            catch (Exception e) {
                throw new SearchException("Unable to instantiate analyzer discriminator implementation: " + discriminatorClass.getName());
            }
            if (annotatedElement instanceof XMember) {
                propertiesMetadata.discriminatorGetter = (XMember)annotatedElement;
            }
        }
    }

    private void checkForFields(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context) {
        Fields fieldsAnn = (Fields)member.getAnnotation(Fields.class);
        NumericFields numericAnns = (NumericFields)member.getAnnotation(NumericFields.class);
        if (fieldsAnn != null) {
            for (Field fieldAnn : fieldsAnn.value()) {
                this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn, this.getNumericExtension(fieldAnn, numericAnns), context);
            }
        }
    }

    private NumericField getNumericExtension(Field fieldAnn, NumericFields numericFields) {
        if (numericFields == null) {
            return null;
        }
        for (NumericField numericField : numericFields.value()) {
            if (!numericField.forField().equals(fieldAnn.name())) continue;
            return numericField;
        }
        return null;
    }

    private void checkForSimilarity(XClass currClass) {
        org.hibernate.search.annotations.Similarity similarityAnn = (org.hibernate.search.annotations.Similarity)currClass.getAnnotation(org.hibernate.search.annotations.Similarity.class);
        if (similarityAnn != null) {
            if (this.similarity != null) {
                throw new SearchException("Multiple similarities defined in the same class hierarchy or on the index settings: " + this.beanXClass.getName());
            }
            Class<?> similarityClass = similarityAnn.impl();
            try {
                this.similarity = (Similarity)similarityClass.newInstance();
            }
            catch (Exception e) {
                log.error("Exception attempting to instantiate Similarity '{}' set for {}", (Object)similarityClass.getName(), (Object)this.beanXClass.getName());
            }
        }
    }

    private void checkForField(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context) {
        Field fieldAnn = (Field)member.getAnnotation(Field.class);
        NumericField numericFieldAnn = (NumericField)member.getAnnotation(NumericField.class);
        DocumentId idAnn = (DocumentId)member.getAnnotation(DocumentId.class);
        if (fieldAnn != null) {
            this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn, numericFieldAnn, context);
        }
        if (fieldAnn == null && idAnn == null && numericFieldAnn != null) {
            throw new SearchException("@NumericField without a @Field on property '" + member.getName() + "'");
        }
    }

    private void checkForContainedIn(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata) {
        ContainedIn containedAnn = (ContainedIn)member.getAnnotation(ContainedIn.class);
        if (containedAnn != null) {
            ReflectionHelper.setAccessible((XMember)member);
            propertiesMetadata.containedInGetters.add((XMember)member);
            this.containedInCollectionRoles.add(StringHelper.qualify((String)classHostingMember.getName(), (String)member.getName()));
        }
    }

    private void checkForIndexedEmbedded(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, Set<XClass> processedClasses, ConfigContext context, Set<XClass> optimizationBlackList, boolean disableOptimizations) {
        IndexedEmbedded embeddedAnn = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class);
        if (embeddedAnn != null) {
            this.indexedEmbeddedCollectionRoles.add(StringHelper.qualify((String)classHostingMember.getName(), (String)member.getName()));
            int oldMaxLevel = this.maxLevel;
            int potentialLevel = embeddedAnn.depth() + this.level;
            if (potentialLevel < 0) {
                potentialLevel = Integer.MAX_VALUE;
            }
            this.maxLevel = potentialLevel > this.maxLevel ? this.maxLevel : potentialLevel;
            ++this.level;
            XClass elementClass = Void.TYPE == embeddedAnn.targetElement() ? member.getElementClass() : this.reflectionManager.toXClass(embeddedAnn.targetElement());
            if (this.maxLevel == Integer.MAX_VALUE && processedClasses.contains(elementClass)) {
                throw new SearchException("Circular reference. Duplicate use of " + elementClass.getName() + " in root entity " + this.beanXClass.getName() + "#" + this.buildEmbeddedPrefix(prefix, embeddedAnn, member));
            }
            if (this.level <= this.maxLevel) {
                processedClasses.add(elementClass);
                ReflectionHelper.setAccessible((XMember)member);
                propertiesMetadata.embeddedGetters.add((XMember)member);
                PropertiesMetadata metadata = new PropertiesMetadata();
                propertiesMetadata.embeddedPropertiesMetadata.add(metadata);
                metadata.boost = this.getBoost(member, null).floatValue();
                Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
                metadata.analyzer = analyzer != null ? analyzer : propertiesMetadata.analyzer;
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                if (disableOptimizations) {
                    optimizationBlackList.add(elementClass);
                }
                this.initializeClass(elementClass, metadata, false, localPrefix, processedClasses, context, optimizationBlackList, disableOptimizations);
                if (member.isArray()) {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.ARRAY);
                } else if (member.isCollection()) {
                    if (Map.class.equals((Object)member.getCollectionClass())) {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.MAP);
                    } else {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.COLLECTION);
                    }
                } else {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.OBJECT);
                }
                processedClasses.remove(elementClass);
            } else if (log.isTraceEnabled()) {
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                log.trace("depth reached, ignoring {}", (Object)localPrefix);
            }
            --this.level;
            this.maxLevel = oldMaxLevel;
        }
    }

    private void bindClassBridgeAnnotation(String prefix, PropertiesMetadata propertiesMetadata, ClassBridge ann, XClass clazz, ConfigContext context) {
        String fieldName = prefix + ann.name();
        propertiesMetadata.classNames.add(fieldName);
        propertiesMetadata.classStores.add(ann.store());
        propertiesMetadata.classIndexes.add(this.getIndex(ann.index()));
        propertiesMetadata.classTermVectors.add(this.getTermVector(ann.termVector()));
        propertiesMetadata.classBridges.add(BridgeFactory.extractType(ann, clazz));
        propertiesMetadata.classBoosts.add(Float.valueOf(ann.boost().value()));
        Analyzer analyzer = this.getAnalyzer(ann.analyzer(), context);
        if (analyzer == null) {
            analyzer = propertiesMetadata.analyzer;
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
        this.addToScopedAnalyzer(fieldName, analyzer, ann.index());
    }

    private void bindFieldAnnotation(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, Field fieldAnn, NumericField numericFieldAnn, ConfigContext context) {
        ReflectionHelper.setAccessible((XMember)member);
        propertiesMetadata.fieldGetters.add((XMember)member);
        String fieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, fieldAnn.name());
        propertiesMetadata.fieldNames.add(fieldName);
        propertiesMetadata.fieldNameToPositionMap.put(member.getName(), propertiesMetadata.fieldNames.size());
        propertiesMetadata.fieldStore.add(fieldAnn.store());
        propertiesMetadata.fieldIndex.add(this.getIndex(fieldAnn.index()));
        propertiesMetadata.fieldBoosts.add(this.getBoost(member, fieldAnn));
        propertiesMetadata.dynamicFieldBoosts.add(this.getDynamicBoost(member));
        propertiesMetadata.fieldTermVectors.add(this.getTermVector(fieldAnn.termVector()));
        propertiesMetadata.precisionSteps.add(this.getPrecisionStep(numericFieldAnn));
        String indexNullAs = fieldAnn.indexNullAs();
        if (indexNullAs.equals("__DO_NOT_INDEX_NULL__")) {
            indexNullAs = null;
        } else if (indexNullAs.equals("__DEFAULT_NULL_TOKEN__")) {
            indexNullAs = context.getDefaultNullToken();
        }
        propertiesMetadata.fieldNullTokens.add(indexNullAs);
        FieldBridge fieldBridge = BridgeFactory.guessType(fieldAnn, numericFieldAnn, (XMember)member, this.reflectionManager);
        if (indexNullAs != null && fieldBridge instanceof TwoWayFieldBridge) {
            fieldBridge = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)fieldBridge, indexNullAs);
        }
        propertiesMetadata.fieldBridges.add(fieldBridge);
        Analyzer analyzer = this.getAnalyzer(fieldAnn.analyzer(), context);
        if (analyzer == null) {
            analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
        }
        this.addToScopedAnalyzer(fieldName, analyzer, fieldAnn.index());
    }

    protected Integer getPrecisionStep(NumericField numericFieldAnn) {
        return numericFieldAnn == null ? 4 : numericFieldAnn.precisionStep();
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded embeddedAnn, XProperty member) {
        String localPrefix = prefix;
        localPrefix = ".".equals(embeddedAnn.prefix()) ? localPrefix + member.getName() + '.' : localPrefix + embeddedAnn.prefix();
        return localPrefix;
    }

    private float getBoost(XClass element) {
        float boost = 1.0f;
        if (element == null) {
            return boost;
        }
        Boost boostAnnotation = (Boost)element.getAnnotation(Boost.class);
        if (boostAnnotation != null) {
            boost = boostAnnotation.value();
        }
        return boost;
    }

    private BoostStrategy getDynamicBoost(XClass element) {
        BoostStrategy strategy;
        if (element == null) {
            return null;
        }
        DynamicBoost boostAnnotation = (DynamicBoost)element.getAnnotation(DynamicBoost.class);
        if (boostAnnotation == null) {
            return new DefaultBoostStrategy();
        }
        Class<? extends BoostStrategy> boostStrategyClass = boostAnnotation.impl();
        try {
            strategy = boostStrategyClass.newInstance();
        }
        catch (Exception e) {
            throw new SearchException("Unable to instantiate boost strategy implementation: " + boostStrategyClass.getName());
        }
        return strategy;
    }

    private <T> Collection<T> getActualCollection(XMember member, Object value) {
        Collection tmpCollection;
        Collection collection = Map.class.equals((Object)member.getCollectionClass()) ? (tmpCollection = ((Map)value).values()) : (tmpCollection = (Collection)value);
        return collection;
    }

    private <T> void processSingleContainedInInstance(WorkPlan workplan, T value) {
        workplan.recurseContainedIn(value);
    }

    public boolean isDirty(String[] dirtyPropertyNames) {
        if (dirtyPropertyNames == null || dirtyPropertyNames.length == 0) {
            return true;
        }
        if (!this.stateInspectionOptimizationsEnabled()) {
            return true;
        }
        for (String dirtyPropertyName : dirtyPropertyNames) {
            Integer propertyIndexInteger = this.metadata.fieldNameToPositionMap.get(dirtyPropertyName);
            if (propertyIndexInteger != null) {
                int propertyIndex = propertyIndexInteger - 1;
                if (this.metadata.fieldIndex.get(propertyIndex).isIndexed()) {
                    return true;
                }
                Store store = this.metadata.fieldStore.get(propertyIndex);
                if (store.equals((Object)Store.YES) || store.equals((Object)Store.COMPRESS)) {
                    return true;
                }
            }
            for (XMember embeddedMember : this.metadata.embeddedGetters) {
                String name = embeddedMember.getName();
                if (!name.equals(dirtyPropertyName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean requiresProvidedId() {
        return false;
    }

    boolean isIdMatchingJpaId() {
        return true;
    }

    public boolean isCollectionRoleExcluded(String collectionRole) {
        if (collectionRole == null) {
            return false;
        }
        if (this.stateInspectionOptimizationsEnabled) {
            return !this.indexedEmbeddedCollectionRoles.contains(collectionRole) && !this.containedInCollectionRoles.contains(collectionRole);
        }
        return false;
    }

    boolean stateInspectionOptimizationsEnabled() {
        if (!this.stateInspectionOptimizationsEnabled) {
            return false;
        }
        if (this.metadata.classBridges.size() > 0) {
            log.trace("State inspection optimization disabled as ClassBridges are enabled on entity {}", (Object)this.beanXClassName);
            return false;
        }
        if (!(this.metadata.classBoostStrategy instanceof DefaultBoostStrategy)) {
            log.trace("State inspection optimization disabled as DynamicBoost is enabled on entity {}", (Object)this.beanXClassName);
            return false;
        }
        return true;
    }

    public void forceStateInspectionOptimizationsDisabled() {
        this.stateInspectionOptimizationsEnabled = false;
    }

    protected static class PropertiesMetadata {
        public float boost;
        public Analyzer analyzer;
        public Discriminator discriminator;
        public XMember discriminatorGetter;
        public BoostStrategy classBoostStrategy;
        public final Map<String, Integer> fieldNameToPositionMap = new HashMap<String, Integer>();
        public final List<String> fieldNames = new ArrayList<String>();
        public final List<XMember> fieldGetters = new ArrayList<XMember>();
        public final List<FieldBridge> fieldBridges = new ArrayList<FieldBridge>();
        public final List<Store> fieldStore = new ArrayList<Store>();
        public final List<Field.Index> fieldIndex = new ArrayList<Field.Index>();
        public final List<Float> fieldBoosts = new ArrayList<Float>();
        public final List<BoostStrategy> dynamicFieldBoosts = new ArrayList<BoostStrategy>();
        public final List<Integer> precisionSteps = new ArrayList<Integer>();
        public final List<String> fieldNullTokens = new LinkedList<String>();
        public final List<Field.TermVector> fieldTermVectors = new ArrayList<Field.TermVector>();
        public final List<XMember> embeddedGetters = new ArrayList<XMember>();
        public final List<PropertiesMetadata> embeddedPropertiesMetadata = new ArrayList<PropertiesMetadata>();
        public final List<Container> embeddedContainers = new ArrayList<Container>();
        public final List<XMember> containedInGetters = new ArrayList<XMember>();
        public final List<String> classNames = new ArrayList<String>();
        public final List<Store> classStores = new ArrayList<Store>();
        public final List<Field.Index> classIndexes = new ArrayList<Field.Index>();
        public final List<FieldBridge> classBridges = new ArrayList<FieldBridge>();
        public final List<Field.TermVector> classTermVectors = new ArrayList<Field.TermVector>();
        public final List<Float> classBoosts = new ArrayList<Float>();

        protected PropertiesMetadata() {
        }

        protected LuceneOptions getClassLuceneOptions(int i) {
            return new LuceneOptionsImpl(this.classStores.get(i), this.classIndexes.get(i), this.classTermVectors.get(i), this.classBoosts.get(i));
        }

        protected LuceneOptions getFieldLuceneOptions(int i, Object value) {
            LuceneOptionsImpl options = new LuceneOptionsImpl(this.fieldStore.get(i), this.fieldIndex.get(i), this.fieldTermVectors.get(i), Float.valueOf(this.fieldBoosts.get(i).floatValue() * this.dynamicFieldBoosts.get(i).defineBoost(value)), this.fieldNullTokens.get(i), this.precisionSteps.get(i));
            return options;
        }

        protected float getClassBoost(Object value) {
            return this.boost * this.classBoostStrategy.defineBoost(value);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Container {
            OBJECT,
            COLLECTION,
            MAP,
            ARRAY;

        }
    }
}

