/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.ContextAwareSelectionDelegate;
import org.hibernate.search.backend.impl.WorkQueuePerIndexSplitter;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;

public class TransactionalSelectionVisitor
implements WorkVisitor<ContextAwareSelectionDelegate> {
    public static final TransactionalSelectionVisitor INSTANCE = new TransactionalSelectionVisitor();
    private final AddSelectionDelegate addDelegate = new AddSelectionDelegate();
    private final DeleteSelectionDelegate deleteDelegate = new DeleteSelectionDelegate();
    private final OptimizeSelectionDelegate optimizeDelegate = new OptimizeSelectionDelegate();
    private final PurgeAllSelectionDelegate purgeDelegate = new PurgeAllSelectionDelegate();

    private TransactionalSelectionVisitor() {
    }

    @Override
    public ContextAwareSelectionDelegate getDelegate(AddLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public ContextAwareSelectionDelegate getDelegate(UpdateLuceneWork addLuceneWork) {
        return this.addDelegate;
    }

    @Override
    public ContextAwareSelectionDelegate getDelegate(DeleteLuceneWork deleteLuceneWork) {
        return this.deleteDelegate;
    }

    @Override
    public ContextAwareSelectionDelegate getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
        return this.optimizeDelegate;
    }

    @Override
    public ContextAwareSelectionDelegate getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
        return this.purgeDelegate;
    }

    private static class PurgeAllSelectionDelegate
    implements ContextAwareSelectionDelegate {
        private PurgeAllSelectionDelegate() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, WorkQueuePerIndexSplitter context) {
            IndexManager[] indexManagers;
            for (IndexManager indexManager : indexManagers = shardingStrategy.getIndexManagersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                context.getIndexManagerQueue(indexManager).add(work);
            }
        }
    }

    private static class OptimizeSelectionDelegate
    implements ContextAwareSelectionDelegate {
        private OptimizeSelectionDelegate() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, WorkQueuePerIndexSplitter context) {
            IndexManager[] indexManagers;
            for (IndexManager indexManager : indexManagers = shardingStrategy.getIndexManagersForAllShards()) {
                indexManager.performStreamOperation(work, false);
            }
        }
    }

    private static class DeleteSelectionDelegate
    implements ContextAwareSelectionDelegate {
        private DeleteSelectionDelegate() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, WorkQueuePerIndexSplitter context) {
            IndexManager[] indexManagers;
            for (IndexManager indexManager : indexManagers = shardingStrategy.getIndexManagersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                context.getIndexManagerQueue(indexManager).add(work);
            }
        }
    }

    private static class AddSelectionDelegate
    implements ContextAwareSelectionDelegate {
        private AddSelectionDelegate() {
        }

        @Override
        public final void performOperation(LuceneWork work, IndexShardingStrategy shardingStrategy, WorkQueuePerIndexSplitter context) {
            IndexManager indexManager = shardingStrategy.getIndexManagersForAddition(work.getEntityClass(), work.getId(), work.getIdInString(), work.getDocument());
            context.getIndexManagerQueue(indexManager).add(work);
        }
    }
}

