/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.batch;

import java.util.Properties;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.StreamingSelectionVisitor;
import org.hibernate.search.backend.impl.TransactionalSelectionVisitor;
import org.hibernate.search.backend.impl.WorkQueuePerIndexSplitter;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.store.IndexShardingStrategy;

public class DefaultBatchBackend
implements BatchBackend {
    public static final String CONCURRENT_WRITERS = "hibernate.search.batchbackend.concurrent_writers";
    private SearchFactoryIntegrator searchFactoryImplementor;

    @Override
    public void initialize(Properties cfg, MassIndexerProgressMonitor monitor, SearchFactoryIntegrator searchFactory) {
        this.searchFactoryImplementor = searchFactory;
    }

    @Override
    public void enqueueAsyncWork(LuceneWork work) throws InterruptedException {
        this.sendWorkToShards(work, true);
    }

    @Override
    public void doWorkInSync(LuceneWork work) {
        this.sendWorkToShards(work, false);
    }

    private void sendWorkToShards(LuceneWork work, boolean forceAsync) {
        Class<?> entityType = work.getEntityClass();
        EntityIndexBinder<?> entityIndexBinding = this.searchFactoryImplementor.getIndexBindingForEntity(entityType);
        IndexShardingStrategy shardingStrategy = entityIndexBinding.getSelectionStrategy();
        if (forceAsync) {
            work.getWorkDelegate(StreamingSelectionVisitor.INSTANCE).performStreamOperation(work, shardingStrategy, forceAsync);
        } else {
            WorkQueuePerIndexSplitter workContext = new WorkQueuePerIndexSplitter();
            work.getWorkDelegate(TransactionalSelectionVisitor.INSTANCE).performOperation(work, shardingStrategy, workContext);
            workContext.commitOperations();
        }
    }
}

