/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.JGroupsMasterMessageListener;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Receiver;

public class MasterJGroupsBackendQueueProcessorFactory
extends JGroupsBackendQueueProcessorFactory {
    private static final Log log = LoggerFactory.make();
    private LuceneBackendQueueProcessorFactory luceneBackendQueueProcessorFactory;
    private Receiver masterListener;

    @Override
    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        super.initialize(props, context, indexManager);
        this.initLuceneBackendQueueProcessorFactory(props, context);
        this.registerMasterListener(context.getUninitializedSearchFactory());
    }

    private void registerMasterListener(SearchFactoryImplementor searchFactory) {
        this.masterListener = new JGroupsMasterMessageListener(searchFactory);
        this.channel.setReceiver(this.masterListener);
    }

    private void initLuceneBackendQueueProcessorFactory(Properties props, WorkerBuildContext context) {
        this.luceneBackendQueueProcessorFactory = new LuceneBackendQueueProcessorFactory();
        this.luceneBackendQueueProcessorFactory.initialize(props, context, this.indexManager);
    }

    public Receiver getMasterListener() {
        return this.masterListener;
    }

    @Override
    public void close() {
        super.close();
        this.luceneBackendQueueProcessorFactory.close();
    }

    @Override
    public void applyWork(List<LuceneWork> workList) {
        this.luceneBackendQueueProcessorFactory.applyWork(workList);
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation) {
        this.luceneBackendQueueProcessorFactory.applyStreamWork(singleOperation);
    }

    @Override
    public Lock getExclusiveWriteLock() {
        log.warnSuspiciousBackendDirectoryCombination(this.indexName);
        return new ReentrantLock();
    }
}

