/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessorFactory;
import org.hibernate.search.indexes.serialization.codex.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JMSBackendQueueProcessor
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Collection<LuceneWork> queue;
    private final JMSBackendQueueProcessorFactory factory;
    private final String indexName;
    private final IndexManager indexManager;

    public JMSBackendQueueProcessor(String indexName, Collection<LuceneWork> queue, IndexManager indexManager, JMSBackendQueueProcessorFactory jmsBackendQueueProcessorFactory) {
        this.indexName = indexName;
        this.queue = queue;
        this.indexManager = indexManager;
        this.factory = jmsBackendQueueProcessorFactory;
    }

    @Override
    public void run() {
        ArrayList<LuceneWork> filteredQueue = new ArrayList<LuceneWork>(this.queue);
        for (LuceneWork work : this.queue) {
            if (!(work instanceof OptimizeLuceneWork)) continue;
            filteredQueue.remove(work);
        }
        if (filteredQueue.size() == 0) {
            return;
        }
        LuceneWorkSerializer serializer = this.indexManager.getSerializer();
        byte[] data = serializer.toSerializedModel(filteredQueue);
        this.factory.prepareJMSTools();
        QueueConnection cnn = null;
        try {
            cnn = this.factory.getJMSFactory().createQueueConnection();
            QueueSession session = cnn.createQueueSession(false, 1);
            ObjectMessage message = session.createObjectMessage();
            message.setObject((Serializable)data);
            message.setStringProperty("hibernate.search.jms.indexNameProperty", this.indexName);
            QueueSender sender = session.createSender(this.factory.getJmsQueue());
            sender.send((Message)message);
            session.close();
        }
        catch (JMSException e) {
            throw new SearchException("Unable to send Search work to JMS queue: " + this.factory.getJmsQueueName(), e);
        }
        finally {
            try {
                if (cnn != null) {
                    cnn.close();
                }
            }
            catch (JMSException e) {
                log.unableToCloseJmsConnection(this.factory.getJmsQueueName(), (Exception)((Object)e));
            }
        }
    }
}

