/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneBackendQueueProcessorFactory
implements BackendQueueProcessor {
    private static final Log log = LoggerFactory.make();
    private LuceneBackendResources resources;
    private boolean sync;

    @Override
    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.sync = BackendFactory.isConfiguredAsSync(props);
        this.resources = new LuceneBackendResources(context, indexManager, props);
    }

    @Override
    public void close() {
        this.resources.shutdown();
    }

    @Override
    public void applyWork(List<LuceneWork> workList) {
        LuceneBackendQueueTask luceneBackendQueueProcessor = new LuceneBackendQueueTask(workList, this.resources);
        if (this.sync) {
            Future<?> future = this.resources.getQueueingExecutor().submit(luceneBackendQueueProcessor);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.interruptedWhileWaitingForIndexActivity();
            }
            catch (ExecutionException e) {
                throw new SearchException("Error applying updates to the Lucene index", e.getCause());
            }
        } else {
            this.resources.getQueueingExecutor().execute(luceneBackendQueueProcessor);
        }
    }

    @Override
    public void applyStreamWork(LuceneWork singleOperation) {
        List<LuceneWork> singletonList = Collections.singletonList(singleOperation);
        this.applyWork(singletonList);
    }

    @Override
    public Lock getExclusiveWriteLock() {
        return this.resources.getExclusiveModificationLock();
    }

    public LuceneBackendResources getIndexResources() {
        return this.resources;
    }
}

