/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.SingleTaskRunnable;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class LuceneBackendQueueTask
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Lock modificationLock;
    private final LuceneBackendResources resources;
    private final List<LuceneWork> queue;

    LuceneBackendQueueTask(List<LuceneWork> queue, LuceneBackendResources resources) {
        this.queue = queue;
        this.resources = resources;
        this.modificationLock = resources.getParallelModificationLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.modificationLock.lock();
        try {
            this.applyUpdates();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.interruptedWhileWaitingForIndexActivity();
            this.handleException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.modificationLock.unlock();
        }
    }

    private void handleException(Exception e) {
        log.backendError(e);
        ErrorContextBuilder builder = new ErrorContextBuilder();
        builder.allWorkToBeDone(this.queue);
        builder.errorThatOccurred(e);
        this.resources.getErrorHandler().handle(builder.createErrorContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdates() throws InterruptedException, ExecutionException {
        AbstractWorkspaceImpl workspace = this.resources.getWorkspace();
        ErrorContextBuilder errorContextBuilder = new ErrorContextBuilder();
        errorContextBuilder.allWorkToBeDone(this.queue);
        IndexWriter indexWriter = workspace.getIndexWriter(errorContextBuilder);
        if (indexWriter == null) {
            log.cannotOpenIndexWriterCausePreviousError();
            return;
        }
        try {
            ExecutorService executor = this.resources.getWorkersExecutor();
            int queueSize = this.queue.size();
            Future[] submittedTasks = new Future[queueSize];
            for (int i = 0; i < queueSize; ++i) {
                SingleTaskRunnable task = new SingleTaskRunnable(this.queue.get(i), this.resources, indexWriter);
                submittedTasks[i] = executor.submit(task);
            }
            boolean someFailureHappened = false;
            LinkedList<LuceneWork> failedUpdates = new LinkedList<LuceneWork>();
            for (int i = 0; i < queueSize; ++i) {
                Future task = submittedTasks[i];
                try {
                    task.get();
                    errorContextBuilder.workCompleted(this.queue.get(i));
                    continue;
                }
                catch (ExecutionException e) {
                    someFailureHappened = true;
                    failedUpdates.add(this.queue.get(i));
                    errorContextBuilder.errorThatOccurred(e.getCause());
                }
            }
            if (someFailureHappened) {
                errorContextBuilder.addAllWorkThatFailed(failedUpdates);
                this.resources.getErrorHandler().handle(errorContextBuilder.createErrorContext());
            }
        }
        finally {
            this.resources.getWorkspace().afterTransactionApplied();
        }
    }
}

