/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.CommonPropertiesParse;
import org.hibernate.search.indexes.serialization.codex.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;

public class DirectoryBasedIndexManager
implements IndexManager {
    private String indexName;
    private final DirectoryProvider directoryProvider;
    private Similarity similarity;
    private BackendQueueProcessor backend;
    private OptimizerStrategy optimizer;
    private LuceneIndexingParameters indexingParameters;
    private final Set<Class<?>> containedEntityTypes = new HashSet();
    private LuceneWorkSerializer serializer;
    private SearchFactoryImplementor boundSearchFactory = null;
    private DirectoryBasedReaderManager readers = null;
    private IndexWriterConfig writerConfig;

    public DirectoryBasedIndexManager(DirectoryProvider directoryProvider) {
        this.directoryProvider = directoryProvider;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public DirectoryBasedReaderManager getIndexReaderManager() {
        return this.readers;
    }

    @Override
    public void destroy() {
        this.readers.stop();
        this.backend.close();
        this.directoryProvider.stop();
    }

    @Override
    public void initialize(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        this.indexName = indexName;
        this.indexingParameters = CommonPropertiesParse.extractIndexingPerformanceOptions(cfg);
        this.optimizer = CommonPropertiesParse.getOptimizerStrategy(this, cfg);
        this.backend = BackendFactory.createBackend(this, buildContext, cfg);
        this.directoryProvider.start(this);
        this.readers = CommonPropertiesParse.createDirectoryBasedReaderManager(this, cfg);
        this.serializer = BackendFactory.createSerializer(indexName, cfg, buildContext);
    }

    @Override
    public Set<Class<?>> getContainedTypes() {
        return this.containedEntityTypes;
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public void setSimilarity(Similarity newSimilarity) {
        this.similarity = newSimilarity;
        if (this.writerConfig != null) {
            this.writerConfig.setSimilarity(this.similarity);
        }
    }

    @Override
    public void performStreamOperation(LuceneWork singleOperation, boolean forceAsync) {
        this.backend.applyStreamWork(singleOperation);
    }

    @Override
    public void performOperations(List<LuceneWork> workList) {
        this.backend.applyWork(workList);
    }

    public String toString() {
        return "DirectoryBasedIndexManager [indexName=" + this.indexName + "]";
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.boundSearchFactory.getAnalyzer(name);
    }

    @Override
    public void setSearchFactory(SearchFactoryImplementor boundSearchFactory) {
        this.boundSearchFactory = boundSearchFactory;
    }

    @Override
    public void addContainedEntity(Class<?> entity) {
        this.containedEntityTypes.add(entity);
    }

    @Override
    public void optimize() {
        this.performStreamOperation(new OptimizeLuceneWork(), false);
    }

    public BackendQueueProcessor getBackendQueueProcessorFactory() {
        return this.backend;
    }

    public void setIndexWriterConfig(IndexWriterConfig writerConfig) {
        this.writerConfig = writerConfig;
    }

    public EntityIndexBinder<?> getIndexBindingForEntity(Class<?> entityType) {
        return this.boundSearchFactory.getIndexBindingForEntity(entityType);
    }

    public Lock getDirectoryModificationLock() {
        return this.backend.getExclusiveWriteLock();
    }

    public DirectoryProvider getDirectoryProvider() {
        return this.directoryProvider;
    }

    public OptimizerStrategy getOptimizerStrategy() {
        return this.optimizer;
    }

    public LuceneIndexingParameters getIndexingParameters() {
        return this.indexingParameters;
    }

    @Override
    public LuceneWorkSerializer getSerializer() {
        return this.serializer;
    }
}

