/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.internals.SearchFactoryImplementorWithShareableState;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.impl.DirectoryProviderFactory;
import org.hibernate.search.store.impl.IdHashShardingStrategy;
import org.hibernate.search.store.impl.NotShardedStrategy;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class IndexManagerHolder {
    private static final String SHARDING_STRATEGY = "sharding_strategy";
    private static final String NBR_OF_SHARDS = "sharding_strategy.nbr_of_shards";
    private final Map<String, IndexManager> indexManagersRegistry = new ConcurrentHashMap<String, IndexManager>();

    public synchronized MutableEntityIndexBinding buildEntityIndexBinding(XClass entity, Class mappedClass, SearchConfiguration cfg, WorkerBuildContext context, ReflectionManager reflectionManager) {
        String directoryProviderName = IndexManagerHolder.getDirectoryProviderName(entity, cfg);
        Properties[] indexProps = IndexManagerHolder.getDirectoryProperties(cfg, directoryProviderName);
        int nbrOfProviders = indexProps.length;
        IndexManager[] providers = new IndexManager[nbrOfProviders];
        for (int index = 0; index < nbrOfProviders; ++index) {
            String providerName = nbrOfProviders > 1 ? directoryProviderName + "." + index : directoryProviderName;
            IndexManager indexManager = this.indexManagersRegistry.get(providerName);
            if (indexManager == null) {
                indexManager = this.createDirectoryManager(providerName, indexProps[index], reflectionManager.toClass(entity), context);
                this.indexManagersRegistry.put(providerName, indexManager);
            }
            indexManager.addContainedEntity(mappedClass);
            providers[index] = indexManager;
        }
        String shardingStrategyName = indexProps[0].getProperty(SHARDING_STRATEGY);
        IndexShardingStrategy shardingStrategy = shardingStrategyName == null ? (indexProps.length == 1 ? new NotShardedStrategy() : new IdHashShardingStrategy()) : ClassLoaderHelper.instanceFromName(IndexShardingStrategy.class, shardingStrategyName, DirectoryProviderFactory.class, "IndexShardingStrategy");
        shardingStrategy.initialize(new MaskedProperty(indexProps[0], SHARDING_STRATEGY), providers);
        String similarityClassName = indexProps[0].getProperty("similarity");
        Similarity similarityInstance = null;
        if (similarityClassName != null) {
            similarityInstance = ClassLoaderHelper.instanceFromName(Similarity.class, similarityClassName, DirectoryProviderFactory.class, "Similarity class for index " + directoryProviderName);
            for (IndexManager manager : providers) {
                this.setSimilarity(similarityInstance, manager);
            }
        }
        return new MutableEntityIndexBinding(shardingStrategy, similarityInstance, providers);
    }

    private void setSimilarity(Similarity newSimilarity, IndexManager manager) {
        Similarity similarity = manager.getSimilarity();
        if (similarity != null && !similarity.getClass().equals(newSimilarity.getClass())) {
            throw new SearchException("Multiple entities are sharing the same index but are declaring an inconsistent Similarity. When overriding default Similarity make sure that all types sharing a same index declare the same Similarity implementation.");
        }
        manager.setSimilarity(newSimilarity);
    }

    private IndexManager createDirectoryManager(String indexName, Properties indexProps, Class<?> entity, WorkerBuildContext context) {
        DirectoryProvider<?> provider = DirectoryProviderFactory.createDirectoryProvider(indexName, indexProps, context);
        DirectoryBasedIndexManager manager = new DirectoryBasedIndexManager(provider);
        manager.initialize(indexName, indexProps, context);
        return manager;
    }

    private static String getDirectoryProviderName(XClass clazz, SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        Class<?> aClass = cfg.getClassMapping(clazz.getName());
        XClass rootIndex = null;
        do {
            XClass currentClazz;
            Indexed indexAnn;
            if ((indexAnn = (Indexed)(currentClazz = reflectionManager.toXClass(aClass)).getAnnotation(Indexed.class)) == null) continue;
            if (indexAnn.index().length() != 0) {
                return indexAnn.index();
            }
            rootIndex = currentClazz;
        } while ((aClass = aClass.getSuperclass()) != null);
        if (rootIndex != null) {
            return rootIndex.getName();
        }
        throw new SearchException("Trying to extract the index name from a non @Indexed class: " + clazz.getName());
    }

    private static Properties[] getDirectoryProperties(SearchConfiguration cfg, String directoryProviderName) {
        MaskedProperty globalProperties;
        MaskedProperty rootCfg = new MaskedProperty(cfg.getProperties(), "hibernate.search");
        MaskedProperty directoryLocalProperties = new MaskedProperty(rootCfg, directoryProviderName, globalProperties = new MaskedProperty(rootCfg, "default"));
        String shardsCountValue = ((Properties)directoryLocalProperties).getProperty(NBR_OF_SHARDS);
        if (shardsCountValue == null) {
            return new Properties[]{directoryLocalProperties};
        }
        int shardsCount = ConfigurationParseHelper.parseInt(shardsCountValue, shardsCountValue + " is not a number");
        Properties[] shardLocalProperties = new Properties[shardsCount];
        for (int i = 0; i < shardsCount; ++i) {
            shardLocalProperties[i] = new MaskedProperty(directoryLocalProperties, Integer.toString(i), directoryLocalProperties);
        }
        return shardLocalProperties;
    }

    public Collection<IndexManager> getIndexManagers() {
        return this.indexManagersRegistry.values();
    }

    public void setActiveSearchFactory(SearchFactoryImplementorWithShareableState factory) {
        for (IndexManager indexManager : this.getIndexManagers()) {
            indexManager.setSearchFactory(factory);
        }
    }

    public synchronized void stop() {
        for (IndexManager indexManager : this.getIndexManagers()) {
            indexManager.destroy();
        }
        this.indexManagersRegistry.clear();
    }

    public IndexManager getIndexManager(String targetIndexName) {
        return this.indexManagersRegistry.get(targetIndexName);
    }
}

