/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.avro.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.serialization.codex.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.codex.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.codex.spi.Deserializer;
import org.hibernate.search.indexes.serialization.codex.spi.LuceneWorksBuilder;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableIndex;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableStore;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableTermVector;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AvroDeserializer
implements Deserializer {
    private static final Log log = LoggerFactory.make();
    private final Protocol protocol;

    public AvroDeserializer(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void deserialize(byte[] data, LuceneWorksBuilder hydrator) {
        GenericRecord result;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        int majorVersion = inputStream.read();
        int minorVersion = inputStream.read();
        if (AvroSerializationProvider.getMajorVersion() != majorVersion) {
            throw new SearchException("Unable to parse message from protocol version " + majorVersion + "." + minorVersion + ". Current protocol version: " + AvroSerializationProvider.getMajorVersion() + "." + AvroSerializationProvider.getMinorVersion());
        }
        if (AvroSerializationProvider.getMinorVersion() < minorVersion && log.isTraceEnabled()) {
            log.tracef("Parsing message from a future protocol version. Some feature might not be propagated. Message version: " + majorVersion + "." + minorVersion + ". Current protocol version: " + AvroSerializationProvider.getMajorVersion() + "." + AvroSerializationProvider.getMinorVersion(), new Object[0]);
        }
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        GenericDatumReader reader = new GenericDatumReader(this.protocol.getType("Message"));
        try {
            result = (GenericRecord)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new SearchException("Unable to deserialize Avro stream", e);
        }
        List<GenericRecord> operations = this.asListOfGenericRecords(result, "operations");
        for (GenericRecord operation : operations) {
            Map<String, String> analyzers;
            String schema = operation.getSchema().getName();
            if ("OptimizeAll".equals(schema)) {
                hydrator.addOptimizeAll();
                continue;
            }
            if ("PurgeAll".equals(schema)) {
                hydrator.addPurgeAllLuceneWork(this.asString(operation, "class"));
                continue;
            }
            if ("Delete".equals(schema)) {
                hydrator.addDeleteLuceneWork(this.asString(operation, "class"), this.asByteArray(operation, "id"));
                continue;
            }
            if ("Add".equals(schema)) {
                this.buildLuceneDocument(this.asGenericRecord(operation, "document"), hydrator);
                analyzers = this.getAnalyzers(operation);
                hydrator.addAddLuceneWork(this.asString(operation, "class"), this.asByteArray(operation, "id"), analyzers);
                continue;
            }
            if ("Update".equals(schema)) {
                this.buildLuceneDocument(this.asGenericRecord(operation, "document"), hydrator);
                analyzers = this.getAnalyzers(operation);
                hydrator.addUpdateLuceneWork(this.asString(operation, "class"), this.asByteArray(operation, "id"), analyzers);
                continue;
            }
            throw new SearchException("Unexpected operation type: " + schema);
        }
    }

    private Map<String, String> getAnalyzers(GenericRecord operation) {
        Map analyzersWithUtf8 = (Map)operation.get("fieldToAnalyzerMap");
        if (analyzersWithUtf8 == null) {
            return null;
        }
        HashMap<String, String> analyzers = new HashMap<String, String>(analyzersWithUtf8.size());
        for (Map.Entry entry : analyzersWithUtf8.entrySet()) {
            analyzers.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return analyzers;
    }

    private void buildLuceneDocument(GenericRecord document, LuceneWorksBuilder hydrator) {
        hydrator.defineDocument(this.asFloat(document, "boost"));
        List<GenericRecord> fieldables = this.asListOfGenericRecords(document, "fieldables");
        for (GenericRecord field : fieldables) {
            String schema = field.getSchema().getName();
            if ("CustomFieldable".equals(schema)) {
                hydrator.addFieldable(this.asByteArray(field, "instance"));
                continue;
            }
            if ("NumericIntField".equals(schema)) {
                hydrator.addIntNumericField(this.asInt(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("NumericFloatField".equals(schema)) {
                hydrator.addFloatNumericField(this.asFloat(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("NumericLongField".equals(schema)) {
                hydrator.addLongNumericField(this.asLong(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("NumericDoubleField".equals(schema)) {
                hydrator.addDoubleNumericField(this.asDouble(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("BinaryField".equals(schema)) {
                hydrator.addFieldWithBinaryData(this.asString(field, "name"), this.asByteArray(field, "value"), this.asInt(field, "offset"), this.asInt(field, "length"), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("StringField".equals(schema)) {
                hydrator.addFieldWithStringData(this.asString(field, "name"), this.asString(field, "value"), this.asStore(field), this.asIndex(field), this.asTermVector(field), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("TokenStreamField".equals(schema)) {
                hydrator.addFieldWithTokenStreamData(this.asString(field, "name"), (List)((Object)SerializationHelper.toSerializable(this.asByteArray(field, "value"), Thread.currentThread().getContextClassLoader())), this.asTermVector(field), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("ReaderField".equals(schema)) {
                hydrator.addFieldWithSerializableReaderData(this.asString(field, "name"), this.asByteArray(field, "value"), this.asTermVector(field), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            throw new SearchException("Unknown Field type: " + schema);
        }
    }

    private GenericRecord asGenericRecord(GenericRecord operation, String field) {
        return (GenericRecord)operation.get(field);
    }

    private List<GenericRecord> asListOfGenericRecords(GenericRecord result, String field) {
        return (List)result.get(field);
    }

    private float asFloat(GenericRecord record, String field) {
        return ((Float)record.get(field)).floatValue();
    }

    private int asInt(GenericRecord record, String field) {
        return (Integer)record.get(field);
    }

    private long asLong(GenericRecord record, String field) {
        return (Long)record.get(field);
    }

    private double asDouble(GenericRecord record, String field) {
        return (Double)record.get(field);
    }

    private String asString(GenericRecord record, String field) {
        return record.get(field).toString();
    }

    private boolean asBoolean(GenericRecord record, String field) {
        return (Boolean)record.get(field);
    }

    private SerializableStore asStore(GenericRecord field) {
        String string = field.get("store").toString();
        return SerializableStore.valueOf(string);
    }

    private SerializableIndex asIndex(GenericRecord field) {
        String string = field.get("index").toString();
        return SerializableIndex.valueOf(string);
    }

    private SerializableTermVector asTermVector(GenericRecord field) {
        String string = field.get("termVector").toString();
        return SerializableTermVector.valueOf(string);
    }

    private byte[] asByteArray(GenericRecord operation, String field) {
        ByteBuffer buffer = (ByteBuffer)operation.get(field);
        byte[] copy = new byte[buffer.remaining()];
        buffer.get(copy);
        return copy;
    }
}

