/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.avro.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Protocol;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.serialization.codex.avro.impl.AvroDeserializer;
import org.hibernate.search.indexes.serialization.codex.avro.impl.AvroSerializer;
import org.hibernate.search.indexes.serialization.codex.spi.Deserializer;
import org.hibernate.search.indexes.serialization.codex.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.codex.spi.Serializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AvroSerializationProvider
implements SerializationProvider {
    private static final Log log = LoggerFactory.make();
    private Map<String, String> schemas = new HashMap<String, String>();
    private static String V1_PATH = "org/hibernate/search/remote/codex/avro/v1/";
    public static byte MAJOR_VERSION = (byte)-127;
    public static byte MINOR_VERSION = (byte)-128;
    private int unique;
    private Protocol protocol;

    public static int getMajorVersion() {
        return MAJOR_VERSION + 128;
    }

    public static int getMinorVersion() {
        return MINOR_VERSION + 128;
    }

    @Override
    public Serializer getSerializer() {
        return new AvroSerializer(this.protocol);
    }

    @Override
    public Deserializer getDeserializer() {
        return new AvroDeserializer(this.protocol);
    }

    public AvroSerializationProvider() {
        log.serializationProtocol(AvroSerializationProvider.getMajorVersion(), AvroSerializationProvider.getMinorVersion());
        this.parseSchema("TermVector");
        this.parseSchema("Index");
        this.parseSchema("Store");
        this.parseSchema("TokenStreamField");
        this.parseSchema("ReaderField");
        this.parseSchema("StringField");
        this.parseSchema("BinaryField");
        this.parseSchema("NumericIntField");
        this.parseSchema("NumericLongField");
        this.parseSchema("NumericFloatField");
        this.parseSchema("NumericDoubleField");
        this.parseSchema("CustomFieldable");
        this.parseSchema("Document");
        this.parseSchema("OptimizeAll");
        this.parseSchema("PurgeAll");
        this.parseSchema("Delete");
        this.parseSchema("Add");
        this.parseSchema("Update");
        this.parseSchema("Message");
        this.protocol = this.parseProtocol("Works");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSchema(String filename) {
        String messageSchemaAsString;
        String fullFileNameileName = V1_PATH + filename + ".avro";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fullFileNameileName);
        try {
            messageSchemaAsString = this.readInputStream(in, fullFileNameileName);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        this.schemas.put(filename, messageSchemaAsString);
    }

    public String readInputStream(InputStream inputStream, String filename) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1000];
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int r = reader.read(buffer);
            while (r != -1) {
                ((Writer)writer).write(buffer, 0, r);
                r = reader.read(buffer);
            }
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new SearchException("Unable to read " + filename, e);
        }
    }

    public Protocol parseProtocol(String name) {
        String filename = V1_PATH + name + ".avpr";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        String protocolSkeleton = this.readInputStream(in, filename);
        String protocolString = this.inlineSchemas(protocolSkeleton);
        return Protocol.parse((String)protocolString);
    }

    public String inlineSchemas(String protocolSkeleton) {
        String result = protocolSkeleton;
        for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
            result = AvroSerializationProvider.replace(result, "`" + entry.getKey() + "`", entry.getValue().toString());
        }
        return result;
    }

    static String replace(String str, String pattern, String replace) {
        int e;
        int s = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }
}

