/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.avro.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.serialization.codex.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.codex.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.codex.spi.Serializer;
import org.hibernate.search.indexes.serialization.operations.impl.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.operations.impl.LuceneNumericFieldContext;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableTermVector;

public class AvroSerializer
implements Serializer {
    private List<GenericRecord> fieldables;
    private List<GenericRecord> operations;
    private GenericRecord document;
    private final Protocol protocol;

    public AvroSerializer(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void luceneWorks(List<LuceneWork> works) {
        this.operations = new ArrayList<GenericRecord>(works.size());
    }

    @Override
    public void addOptimizeAll() {
        this.operations.add((GenericRecord)new GenericData.Record(this.protocol.getType("OptimizeAll")));
    }

    @Override
    public void addPurgeAll(String entityClassName) {
        GenericData.Record purgeAll = new GenericData.Record(this.protocol.getType("PurgeAll"));
        purgeAll.put("class", (Object)entityClassName);
        this.operations.add((GenericRecord)purgeAll);
    }

    @Override
    public void addDelete(String entityClassName, byte[] id) {
        GenericData.Record delete = new GenericData.Record(this.protocol.getType("Delete"));
        delete.put("class", (Object)entityClassName);
        delete.put("id", (Object)ByteBuffer.wrap(id));
        this.operations.add((GenericRecord)delete);
    }

    @Override
    public void addAdd(String entityClassName, byte[] id, Map<String, String> fieldToAnalyzerMap) {
        GenericData.Record add = new GenericData.Record(this.protocol.getType("Add"));
        add.put("class", (Object)entityClassName);
        add.put("id", (Object)ByteBuffer.wrap(id));
        add.put("document", (Object)this.document);
        add.put("fieldToAnalyzerMap", fieldToAnalyzerMap);
        this.operations.add((GenericRecord)add);
        this.clearDocument();
    }

    @Override
    public void addUpdate(String entityClassName, byte[] id, Map<String, String> fieldToAnalyzerMap) {
        GenericData.Record update = new GenericData.Record(this.protocol.getType("Update"));
        update.put("class", (Object)entityClassName);
        update.put("id", (Object)ByteBuffer.wrap(id));
        update.put("document", (Object)this.document);
        update.put("fieldToAnalyzerMap", fieldToAnalyzerMap);
        this.operations.add((GenericRecord)update);
        this.clearDocument();
    }

    @Override
    public byte[] serialize() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(AvroSerializationProvider.getMajorVersion());
        out.write(AvroSerializationProvider.getMinorVersion());
        Schema msgSchema = this.protocol.getType("Message");
        GenericDatumWriter writer = new GenericDatumWriter(msgSchema);
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        GenericData.Record message = new GenericData.Record(msgSchema);
        message.put("operations", this.operations);
        this.operations = null;
        try {
            writer.write((Object)message, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw new SearchException("Unable to serialize message with Avro", e);
        }
        return out.toByteArray();
    }

    @Override
    public void fields(List<Fieldable> fields) {
        this.fieldables = new ArrayList<GenericRecord>(fields.size());
    }

    @Override
    public void addIntNumericField(int value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericIntField", context);
        numericField.put("value", (Object)value);
        this.fieldables.add(numericField);
    }

    private GenericRecord createNumericfield(String schemaName, LuceneNumericFieldContext context) {
        GenericData.Record numericField = new GenericData.Record(this.protocol.getType(schemaName));
        numericField.put("name", (Object)context.getName());
        numericField.put("precisionStep", (Object)context.getPrecisionStep());
        numericField.put("store", (Object)context.getStore());
        numericField.put("indexed", (Object)context.isIndexed());
        numericField.put("boost", (Object)Float.valueOf(context.getBoost()));
        numericField.put("omitNorms", (Object)context.getOmitNorms());
        numericField.put("omitTermFreqAndPositions", (Object)context.getOmitTermFreqAndPositions());
        return numericField;
    }

    @Override
    public void addLongNumericField(long value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericLongField", context);
        numericField.put("value", (Object)value);
        this.fieldables.add(numericField);
    }

    @Override
    public void addFloatNumericField(float value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericFloatField", context);
        numericField.put("value", (Object)Float.valueOf(value));
        this.fieldables.add(numericField);
    }

    @Override
    public void addDoubleNumericField(double value, LuceneNumericFieldContext context) {
        GenericRecord numericField = this.createNumericfield("NumericDoubleField", context);
        numericField.put("value", (Object)value);
        this.fieldables.add(numericField);
    }

    @Override
    public void addFieldWithBinaryData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("BinaryField", context);
        field.put("offset", (Object)context.getBinaryOffset());
        field.put("length", (Object)context.getBinaryLength());
        field.put("value", (Object)ByteBuffer.wrap(context.getBinaryValue()));
        this.fieldables.add(field);
    }

    private GenericRecord createNormalField(String schemaName, LuceneFieldContext context) {
        GenericData.Record field = new GenericData.Record(this.protocol.getType(schemaName));
        field.put("name", (Object)context.getName());
        field.put("boost", (Object)Float.valueOf(context.getBoost()));
        field.put("omitNorms", (Object)context.isOmitNorms());
        field.put("omitTermFreqAndPositions", (Object)context.isOmitTermFreqAndPositions());
        return field;
    }

    @Override
    public void addFieldWithStringData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("StringField", context);
        field.put("value", (Object)context.getStringValue());
        field.put("store", (Object)context.getStore());
        field.put("index", (Object)context.getIndex());
        field.put("termVector", (Object)context.getTermVector());
        this.fieldables.add(field);
    }

    @Override
    public void addFieldWithTokenStreamData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("TokenStreamField", context);
        field.put("value", context.getTokenStream().getStream());
        SerializableTermVector termVector = context.getTermVector();
        byte[] data = SerializationHelper.toByteArray((Serializable)((Object)termVector));
        field.put("termVector", (Object)ByteBuffer.wrap(data));
        this.fieldables.add(field);
    }

    @Override
    public void addFieldWithSerializableReaderData(LuceneFieldContext context) {
        GenericRecord field = this.createNormalField("ReaderField", context);
        field.put("value", (Object)ByteBuffer.wrap(context.getReaderValue()));
        field.put("termVector", (Object)context.getTermVector());
        this.fieldables.add(field);
    }

    @Override
    public void addFieldWithSerializableFieldable(byte[] fieldable) {
        GenericData.Record customFieldable = new GenericData.Record(this.protocol.getType("CustomFieldable"));
        customFieldable.put("instance", (Object)ByteBuffer.wrap(fieldable));
        this.fieldables.add((GenericRecord)customFieldable);
    }

    @Override
    public void addDocument(float boost) {
        this.document = new GenericData.Record(this.protocol.getType("Document"));
        this.document.put("boost", (Object)Float.valueOf(boost));
        this.document.put("fieldables", this.fieldables);
    }

    private void clearDocument() {
        this.document = null;
        this.fieldables = null;
    }
}

