/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.AttributeImpl;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableTokenStream;

public class CopyTokenStream
extends TokenStream {
    private List<List<AttributeImpl>> cache;
    private int index = 0;

    public static SerializableTokenStream buildSerializabletokenStream(TokenStream tokenStream) {
        try {
            List<List<AttributeImpl>> stream = CopyTokenStream.fillCache(tokenStream);
            return new SerializableTokenStream(stream);
        }
        catch (IOException e) {
            throw new SearchException("Unable to read token stream", e);
        }
    }

    public CopyTokenStream(List<List<AttributeImpl>> stream) {
        this.cache = stream;
    }

    public final boolean incrementToken() throws IOException {
        if (this.index >= this.cache.size()) {
            return false;
        }
        this.setState(this.index);
        ++this.index;
        return true;
    }

    private void setState(int localIndex) {
        for (AttributeImpl attr : this.cache.get(localIndex)) {
            this.addAttributeImpl(attr);
        }
    }

    public final void end() throws IOException {
        if (this.cache.size() > 0) {
            this.setState(this.cache.size() - 1);
        }
    }

    public void reset() throws IOException {
        this.index = 0;
    }

    private static List<List<AttributeImpl>> fillCache(TokenStream input) throws IOException {
        ArrayList<List<AttributeImpl>> results = new ArrayList<List<AttributeImpl>>();
        while (input.incrementToken()) {
            ArrayList<AttributeImpl> attrs = new ArrayList<AttributeImpl>();
            results.add(attrs);
            Iterator iter = input.getAttributeImplsIterator();
            while (iter.hasNext()) {
                attrs.add((AttributeImpl)((AttributeImpl)iter.next()).clone());
            }
        }
        input.end();
        return results;
    }
}

