/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.serialization.codex.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.codex.spi.Serializer;
import org.hibernate.search.indexes.serialization.operations.impl.Add;
import org.hibernate.search.indexes.serialization.operations.impl.Delete;
import org.hibernate.search.indexes.serialization.operations.impl.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.operations.impl.LuceneNumericFieldContext;
import org.hibernate.search.indexes.serialization.operations.impl.Message;
import org.hibernate.search.indexes.serialization.operations.impl.Operation;
import org.hibernate.search.indexes.serialization.operations.impl.OptimizeAll;
import org.hibernate.search.indexes.serialization.operations.impl.PurgeAll;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableBinaryField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableCustomFieldable;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableDocument;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableDoubleField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableFieldable;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableFloatField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableIntField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableLongField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableReaderField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableStringField;
import org.hibernate.search.indexes.serialization.operations.impl.SerializableTokenStreamField;
import org.hibernate.search.indexes.serialization.operations.impl.Update;

public class ModelSerializer
implements Serializer {
    private Set<Operation> ops;
    private Set<SerializableFieldable> serialFields;
    private SerializableDocument currentDocument;

    @Override
    public void luceneWorks(List<LuceneWork> works) {
        this.ops = new HashSet<Operation>(works.size());
    }

    @Override
    public void addOptimizeAll() {
        this.ops.add(new OptimizeAll());
    }

    @Override
    public void addPurgeAll(String entityClassName) {
        this.ops.add(new PurgeAll(entityClassName));
    }

    @Override
    public void addDelete(String entityClassName, byte[] id) {
        this.ops.add(new Delete(entityClassName, id));
    }

    @Override
    public void addAdd(String entityClassName, byte[] id, Map<String, String> fieldToAnalyzerMap) {
        this.ops.add(new Add(entityClassName, id, this.currentDocument, fieldToAnalyzerMap));
        this.clearDocument();
    }

    @Override
    public void addUpdate(String entityClassName, byte[] id, Map<String, String> fieldToAnalyzerMap) {
        this.ops.add(new Update(entityClassName, id, this.currentDocument, fieldToAnalyzerMap));
        this.clearDocument();
    }

    @Override
    public byte[] serialize() {
        Message message = new Message(this.ops);
        return SerializationHelper.toByteArray(message);
    }

    @Override
    public void fields(List<Fieldable> fields) {
        this.serialFields = new HashSet<SerializableFieldable>(fields.size());
    }

    @Override
    public void addIntNumericField(int value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableIntField(value, context));
    }

    @Override
    public void addLongNumericField(long value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableLongField(value, context));
    }

    @Override
    public void addFloatNumericField(float value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableFloatField(value, context));
    }

    @Override
    public void addDoubleNumericField(double value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableDoubleField(value, context));
    }

    @Override
    public void addFieldWithBinaryData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableBinaryField(luceneFieldContext));
    }

    @Override
    public void addFieldWithStringData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableStringField(luceneFieldContext));
    }

    @Override
    public void addFieldWithTokenStreamData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableTokenStreamField(luceneFieldContext));
    }

    @Override
    public void addFieldWithSerializableReaderData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableReaderField(luceneFieldContext));
    }

    @Override
    public void addFieldWithSerializableFieldable(byte[] fieldable) {
        this.serialFields.add(new SerializableCustomFieldable(fieldable));
    }

    @Override
    public void addDocument(float boost) {
        this.currentDocument = new SerializableDocument(this.serialFields, boost);
    }

    private void clearDocument() {
        this.currentDocument = null;
        this.serialFields = null;
    }
}

