/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.codex.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.serialization.codex.impl.LuceneWorkHydrator;
import org.hibernate.search.indexes.serialization.codex.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.codex.spi.Deserializer;
import org.hibernate.search.indexes.serialization.codex.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.codex.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.codex.spi.Serializer;
import org.hibernate.search.indexes.serialization.operations.impl.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.operations.impl.LuceneNumericFieldContext;

public class PluggableSerializationLuceneWorkSerializer
implements LuceneWorkSerializer {
    private SearchFactoryImplementor searchFactory;
    private SerializationProvider provider;

    public PluggableSerializationLuceneWorkSerializer(SerializationProvider provider, SearchFactoryImplementor searchFactory) {
        this.provider = provider;
        this.searchFactory = searchFactory;
    }

    @Override
    public byte[] toSerializedModel(List<LuceneWork> works) {
        Serializer serializer = this.provider.getSerializer();
        serializer.luceneWorks(works);
        for (LuceneWork work : works) {
            if (work instanceof OptimizeLuceneWork) {
                serializer.addOptimizeAll();
                continue;
            }
            if (work instanceof PurgeAllLuceneWork) {
                serializer.addPurgeAll(work.getEntityClass().getName());
                continue;
            }
            if (work instanceof DeleteLuceneWork) {
                serializer.addDelete(work.getEntityClass().getName(), SerializationHelper.toByteArray(work.getId()));
                continue;
            }
            if (work instanceof AddLuceneWork) {
                this.buildDocument(work.getDocument(), serializer);
                serializer.addAdd(work.getEntityClass().getName(), SerializationHelper.toByteArray(work.getId()), work.getFieldToAnalyzerMap());
                continue;
            }
            if (!(work instanceof UpdateLuceneWork)) continue;
            this.buildDocument(work.getDocument(), serializer);
            serializer.addUpdate(work.getEntityClass().getName(), SerializationHelper.toByteArray(work.getId()), work.getFieldToAnalyzerMap());
        }
        return serializer.serialize();
    }

    @Override
    public List<LuceneWork> toLuceneWorks(byte[] data) {
        Deserializer deserializer = this.provider.getDeserializer();
        LuceneWorkHydrator hydrator = new LuceneWorkHydrator(this.searchFactory);
        deserializer.deserialize(data, hydrator);
        return hydrator.getLuceneWorks();
    }

    private void buildDocument(Document document, Serializer serializer) {
        List docFields = document.getFields();
        serializer.fields(docFields);
        for (Fieldable fieldable : docFields) {
            NumericField safeField;
            if (fieldable instanceof NumericField) {
                safeField = (NumericField)fieldable;
                LuceneNumericFieldContext context = new LuceneNumericFieldContext((NumericField)fieldable);
                switch (safeField.getDataType()) {
                    case INT: {
                        serializer.addIntNumericField(safeField.getNumericValue().intValue(), context);
                        break;
                    }
                    case LONG: {
                        serializer.addLongNumericField(safeField.getNumericValue().longValue(), context);
                        break;
                    }
                    case FLOAT: {
                        serializer.addFloatNumericField(safeField.getNumericValue().floatValue(), context);
                        break;
                    }
                    case DOUBLE: {
                        serializer.addDoubleNumericField(safeField.getNumericValue().doubleValue(), context);
                        break;
                    }
                    default: {
                        throw new SearchException("Unknown NumericField type: " + safeField.getDataType());
                    }
                }
                continue;
            }
            if (fieldable instanceof Field) {
                safeField = (Field)fieldable;
                if (safeField.isBinary()) {
                    serializer.addFieldWithBinaryData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                if (safeField.stringValue() != null) {
                    serializer.addFieldWithStringData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                if (safeField.readerValue() != null && safeField.readerValue() instanceof Serializable) {
                    serializer.addFieldWithSerializableReaderData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                if (safeField.readerValue() != null) {
                    throw new SearchException("Conversion from Reader to String not yet implemented");
                }
                if (safeField.tokenStreamValue() != null) {
                    serializer.addFieldWithTokenStreamData(new LuceneFieldContext((Field)safeField));
                    continue;
                }
                throw new SearchException("Unknown value type for Field: " + safeField);
            }
            if (fieldable instanceof Serializable) {
                serializer.addFieldWithSerializableFieldable(SerializationHelper.toByteArray((Serializable)fieldable));
                continue;
            }
            throw new SearchException("Cannot serialize custom field '" + fieldable.getClass() + "'. Must be NumericField, Field or a Serializable Fieldable implementation.");
        }
        serializer.addDocument(document.getBoost());
    }
}

