/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.Date;
import java.util.List;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.util.impl.CollectionHelper;

class FacetBuildingContext<T> {
    private static final List<Class<?>> allowedRangeTypes = CollectionHelper.newArrayList();
    private final SearchFactoryImplementor factory;
    private final Class<?> entityType;
    private String name;
    private String fieldName;
    private FacetSortOrder sort = FacetSortOrder.COUNT_DESC;
    private boolean includeZeroCount = true;
    private boolean isRangeQuery = false;
    private List<FacetRange<T>> rangeList = CollectionHelper.newArrayList();
    private T rangeStart;
    private boolean includeRangeStart = true;
    private T rangeEnd;
    private boolean includeRangeEnd = true;
    private int maxFacetCount = -1;
    private DocumentBuilderIndexedEntity<?> documentBuilder;

    public FacetBuildingContext(SearchFactoryImplementor factory, Class<?> entityType) {
        this.factory = factory;
        this.entityType = entityType;
    }

    void setName(String name) {
        this.name = name;
    }

    void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        this.assertFacetingFieldExists();
    }

    void setSort(FacetSortOrder sort) {
        this.sort = sort;
    }

    void setIncludeZeroCount(boolean includeZeroCount) {
        this.includeZeroCount = includeZeroCount;
    }

    public void setRangeQuery(boolean rangeQuery) {
        this.isRangeQuery = rangeQuery;
    }

    public void setRangeStart(T rangeStart) {
        this.rangeStart = rangeStart;
    }

    public void setIncludeRangeStart(boolean includeRangeStart) {
        this.includeRangeStart = includeRangeStart;
    }

    public void setRangeEnd(T rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    public void setIncludeRangeEnd(boolean includeRangeEnd) {
        this.includeRangeEnd = includeRangeEnd;
    }

    public void setMaxFacetCount(int maxFacetCount) {
        this.maxFacetCount = maxFacetCount;
    }

    public void makeRange() {
        Class<?> type = this.getRangeType();
        this.assertValidRangeType(type);
        FacetRange<T> facetRange = new FacetRange<T>(type, this.rangeStart, this.rangeEnd, this.includeRangeStart, this.includeRangeEnd, this.fieldName, this.documentBuilder);
        this.rangeList.add(facetRange);
        this.rangeStart = null;
        this.rangeEnd = null;
        this.includeRangeStart = true;
        this.includeRangeEnd = true;
    }

    private void assertValidRangeType(Class<?> clazz) {
        if (!allowedRangeTypes.contains(clazz)) {
            throw new SearchException("Unsupported range type: " + clazz.getName());
        }
    }

    private Class<?> getRangeType() {
        if (this.rangeStart == null && this.rangeEnd == null) {
            throw new SearchException("You have to at least specify a start or end of the range");
        }
        T tmp = this.rangeStart;
        if (tmp == null) {
            tmp = this.rangeEnd;
        }
        return tmp.getClass();
    }

    FacetingRequest getFacetingRequest() {
        FacetingRequestImpl request;
        if (this.isRangeQuery) {
            request = new RangeFacetRequest<T>(this.name, this.fieldName, this.rangeList, this.documentBuilder);
        } else {
            if (FacetSortOrder.RANGE_DEFINITION_ODER.equals((Object)this.sort)) {
                throw new SearchException("RANGE_DEFINITION_ODER is not a valid sort order for a discrete faceting request.");
            }
            request = new DiscreteFacetRequest(this.name, this.fieldName);
        }
        request.setSort(this.sort);
        request.setIncludeZeroCounts(this.includeZeroCount);
        request.setMaxNumberOfFacets(this.maxFacetCount);
        return request;
    }

    private void assertFacetingFieldExists() {
        if (this.fieldName == null) {
            throw new IllegalArgumentException("null is an invalid field name");
        }
        EntityIndexBinder<?> indexBinding = this.factory.getIndexBindingForEntity(this.entityType);
        if (indexBinding == null) {
            throw new SearchException("Entity " + this.entityType.getName() + " is not an indexed entity. Unable to create faceting request");
        }
        this.documentBuilder = indexBinding.getDocumentBuilder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FacetBuildingContext");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", sort=").append((Object)this.sort);
        sb.append(", includeZeroCount=").append(this.includeZeroCount);
        sb.append(", isRangeQuery=").append(this.isRangeQuery);
        sb.append(", rangeList=").append(this.rangeList);
        sb.append(", rangeStart=").append(this.rangeStart);
        sb.append(", includeRangeStart=").append(this.includeRangeStart);
        sb.append(", rangeEnd=").append(this.rangeEnd);
        sb.append(", includeRangeEnd=").append(this.includeRangeEnd);
        sb.append('}');
        return sb.toString();
    }

    static {
        allowedRangeTypes.add(String.class);
        allowedRangeTypes.add(Integer.class);
        allowedRangeTypes.add(Long.class);
        allowedRangeTypes.add(Double.class);
        allowedRangeTypes.add(Float.class);
        allowedRangeTypes.add(Date.class);
    }
}

