/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LookupObjectsInitializer
implements ObjectsInitializer {
    private static final Log log = LoggerFactory.make();
    public static final LookupObjectsInitializer INSTANCE = new LookupObjectsInitializer();

    private LookupObjectsInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager, Session session) {
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            log.tracef("No object to initialize", maxResults);
            return;
        }
        for (EntityInfo entityInfo : entityInfos) {
            ObjectLoaderHelper.load(entityInfo, session);
        }
        log.tracef("Initialized %d objects by lookup method.", maxResults);
    }
}

