/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;

public class IdHashShardingStrategy
implements IndexShardingStrategy {
    private IndexManager[] providers;

    @Override
    public void initialize(Properties properties, IndexManager[] providers) {
        this.providers = providers;
    }

    @Override
    public IndexManager[] getIndexManagersForAllShards() {
        return this.providers;
    }

    @Override
    public IndexManager getIndexManagersForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        return this.providers[this.hashKey(idInString)];
    }

    @Override
    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        if (idInString == null) {
            return this.providers;
        }
        return new IndexManager[]{this.providers[this.hashKey(idInString)]};
    }

    @Override
    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.getIndexManagersForAllShards();
    }

    private int hashKey(String key) {
        int hash = 0;
        int length = key.length();
        for (int index = 0; index < length; ++index) {
            hash = 31 * hash + key.charAt(index);
        }
        return Math.abs(hash % this.providers.length);
    }
}

