/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;

public abstract class AbstractWorkspaceImpl
implements Workspace {
    private final OptimizerStrategy optimizerStrategy;
    private final Set<Class<?>> entitiesInIndexManager;
    private final DirectoryBasedIndexManager indexManager;
    protected final IndexWriterHolder writerHolder;
    private final AtomicLong operations = new AtomicLong(0L);

    public AbstractWorkspaceImpl(DirectoryBasedIndexManager indexManager, ErrorHandler errorHandler) {
        this.indexManager = indexManager;
        this.optimizerStrategy = indexManager.getOptimizerStrategy();
        this.entitiesInIndexManager = indexManager.getContainedTypes();
        this.writerHolder = new IndexWriterHolder(errorHandler, indexManager);
    }

    @Override
    public <T> DocumentBuilderIndexedEntity<?> getDocumentBuilder(Class<T> entity) {
        return this.indexManager.getIndexBindingForEntity(entity).getDocumentBuilder();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.indexManager.getAnalyzer(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimizerPhase() {
        OptimizerStrategy optimizerStrategy = this.optimizerStrategy;
        synchronized (optimizerStrategy) {
            this.optimizerStrategy.addTransaction(this.operations.getAndSet(0L));
            this.optimizerStrategy.optimize(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize() {
        OptimizerStrategy optimizerStrategy = this.optimizerStrategy;
        synchronized (optimizerStrategy) {
            this.optimizerStrategy.optimizationForced();
        }
    }

    @Override
    public void incrementModificationCounter(int modCount) {
        this.operations.addAndGet(modCount);
    }

    @Override
    public Set<Class<?>> getEntitiesInIndexManager() {
        return this.entitiesInIndexManager;
    }

    @Override
    public abstract void afterTransactionApplied();

    public void shutDownNow() {
        this.writerHolder.forceLockRelease();
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this.writerHolder.getIndexWriter();
    }

    public IndexWriter getIndexWriter(ErrorContextBuilder errorContextBuilder) {
        return this.writerHolder.getIndexWriter(errorContextBuilder);
    }
}

