/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.impl.lucene.overrides.ConcurrentMergeScheduler;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.exception.impl.SingleErrorContext;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class IndexWriterHolder {
    private static final Log log = LoggerFactory.make();
    private static final Analyzer SIMPLE_ANALYZER = new SimpleAnalyzer(Version.LUCENE_33);
    private final IndexWriterConfig writerConfig = new IndexWriterConfig(Version.LUCENE_33, SIMPLE_ANALYZER);
    private final LuceneIndexingParameters luceneParameters;
    private final ErrorHandler errorHandler;
    private final LuceneIndexingParameters.ParameterSet indexParameters;
    private final DirectoryProvider directoryProvider;
    private final String indexName;
    private IndexWriter writer;

    IndexWriterHolder(ErrorHandler errorHandler, DirectoryBasedIndexManager indexManager) {
        this.errorHandler = errorHandler;
        this.indexName = indexManager.getIndexName();
        this.luceneParameters = indexManager.getIndexingParameters();
        this.indexParameters = this.luceneParameters.getIndexParameters();
        this.directoryProvider = indexManager.getDirectoryProvider();
        this.luceneParameters.applyToWriter(this.writerConfig);
        Similarity similarity = indexManager.getSimilarity();
        if (similarity != null) {
            this.writerConfig.setSimilarity(similarity);
        }
        indexManager.setIndexWriterConfig(this.writerConfig);
    }

    public synchronized IndexWriter getIndexWriter(ErrorContextBuilder errorContextBuilder) {
        if (this.writer != null) {
            return this.writer;
        }
        try {
            this.writer = this.createNewIndexWriter();
            log.trace("IndexWriter opened");
        }
        catch (IOException ioe) {
            this.writer = null;
            this.handleIOException(ioe, errorContextBuilder);
        }
        return this.writer;
    }

    public IndexWriter getIndexWriter() {
        return this.getIndexWriter(null);
    }

    private IndexWriter createNewIndexWriter() throws IOException {
        LogByteSizeMergePolicy newMergePolicy = this.indexParameters.getNewMergePolicy();
        this.writerConfig.setMergePolicy((MergePolicy)newMergePolicy);
        ConcurrentMergeScheduler mergeScheduler = new ConcurrentMergeScheduler(this.errorHandler);
        this.writerConfig.setMergeScheduler((MergeScheduler)mergeScheduler);
        IndexWriter writer = new IndexWriter(this.directoryProvider.getDirectory(), this.writerConfig);
        return writer;
    }

    public synchronized void commitIndexWriter(ErrorContextBuilder errorContextBuilder) {
        if (this.writer != null) {
            try {
                this.writer.commit();
                log.trace("Index changes commited.");
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, errorContextBuilder);
            }
        }
    }

    public void commitIndexWriter() {
        this.commitIndexWriter(null);
    }

    public synchronized void closeIndexWriter() {
        IndexWriter toClose = this.writer;
        this.writer = null;
        if (toClose != null) {
            try {
                toClose.close();
                log.trace("IndexWriter closed");
            }
            catch (IOException ioe) {
                this.handleIOException(ioe, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forceLockRelease() {
        log.forcingReleaseIndexWriterLock();
        try {
            try {
                if (this.writer != null) {
                    this.writer.close();
                    log.trace("IndexWriter closed");
                }
            }
            finally {
                this.writer = null;
                IndexWriter.unlock(this.directoryProvider.getDirectory());
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe, null);
        }
    }

    public synchronized IndexReader openNRTIndexReader(boolean applyDeletes) {
        try {
            if (this.writer != null) {
                return IndexReader.open((IndexWriter)this.writer, (boolean)applyDeletes);
            }
            return null;
        }
        catch (CorruptIndexException cie) {
            throw log.cantOpenCorruptedIndex(cie, this.indexName);
        }
        catch (IOException ioe) {
            throw log.ioExceptionOnIndex(ioe, this.indexName);
        }
    }

    public IndexReader openDirectoryIndexReader() {
        try {
            return IndexReader.open(this.directoryProvider.getDirectory(), (boolean)true);
        }
        catch (CorruptIndexException cie) {
            throw log.cantOpenCorruptedIndex(cie, this.indexName);
        }
        catch (IOException ioe) {
            throw log.ioExceptionOnIndex(ioe, this.indexName);
        }
    }

    private void handleIOException(IOException ioe, ErrorContextBuilder errorContextBuilder) {
        if (log.isTraceEnabled()) {
            log.trace("going to handle IOException", ioe);
        }
        ErrorContext errorContext = errorContextBuilder != null ? errorContextBuilder.errorThatOccurred(ioe).createErrorContext() : new SingleErrorContext(ioe);
        this.errorHandler.handle(errorContext);
    }
}

