/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.spi.internals.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.internals.SearchFactoryImplementorWithShareableState;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.spi.StatisticsImplementor;
import org.hibernate.search.store.DirectoryProvider;

public class MutableSearchFactory
implements SearchFactoryImplementorWithShareableState,
SearchFactoryIntegrator {
    private volatile SearchFactoryImplementorWithShareableState delegate;
    private final Lock mutating = new ReentrantLock();

    public void setDelegate(SearchFactoryImplementorWithShareableState delegate) {
        this.delegate = delegate;
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.delegate.getFilterDefinitions();
    }

    @Override
    public Map<Class<?>, EntityIndexBinder<?>> getIndexBindingForEntity() {
        return this.delegate.getIndexBindingForEntity();
    }

    @Override
    public <T> EntityIndexBinder<T> getIndexBindingForEntity(Class<T> entityType) {
        return this.delegate.getIndexBindingForEntity(entityType);
    }

    @Override
    public <T> DocumentBuilderContainedEntity<T> getDocumentBuilderContainedEntity(Class<T> entityType) {
        return this.delegate.getDocumentBuilderContainedEntity(entityType);
    }

    @Override
    public Worker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.delegate.getFilterCachingStrategy();
    }

    @Override
    public Map<String, Analyzer> getAnalyzers() {
        return this.delegate.getAnalyzers();
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.delegate.getCacheBitResultsSize();
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.delegate.getConfigurationProperties();
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.delegate.getFilterDefinition(name);
    }

    @Override
    public String getIndexingStrategy() {
        return this.delegate.getIndexingStrategy();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public HSQuery createHSQuery() {
        return this.delegate.createHSQuery();
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        return this.delegate.getFilterCacheBitResultsSize();
    }

    @Override
    public Set<Class<?>> getIndexedTypesPolymorphic(Class<?>[] classes) {
        return this.delegate.getIndexedTypesPolymorphic(classes);
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        return this.delegate.makeBatchBackend(progressMonitor);
    }

    @Override
    public boolean isJMXEnabled() {
        return this.delegate.isJMXEnabled();
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.delegate.getStatisticsImplementor();
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.delegate.getIndexHierarchy();
    }

    @Override
    public Map<DirectoryProvider, LuceneIndexingParameters> getDirectoryProviderIndexingParams() {
        return this.delegate.getDirectoryProviderIndexingParams();
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.delegate.getServiceManager();
    }

    @Override
    public void optimize() {
        this.delegate.optimize();
    }

    @Override
    public void optimize(Class entityType) {
        this.delegate.optimize(entityType);
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.delegate.getAnalyzer(name);
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        return this.delegate.getAnalyzer(clazz);
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return this.delegate.buildQueryBuilder();
    }

    @Override
    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity<?>> getDocumentBuildersContainedEntities() {
        return this.delegate.getDocumentBuildersContainedEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClasses(Class<?> ... classes) {
        SearchFactoryBuilder builder = new SearchFactoryBuilder().currentFactory(this);
        for (Class<?> type : classes) {
            builder.addClass(type);
        }
        try {
            this.mutating.lock();
            builder.buildSearchFactory();
        }
        finally {
            this.mutating.unlock();
        }
    }

    @Override
    public boolean isDirtyChecksEnabled() {
        return this.delegate.isDirtyChecksEnabled();
    }

    @Override
    public boolean isStopped() {
        return this.delegate.isStopped();
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.delegate.isTransactionManagerExpected();
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.delegate.getAllIndexesManager();
    }

    @Override
    public IndexReader openIndexReader(Class<?> ... entities) {
        return this.delegate.openIndexReader(entities);
    }

    @Override
    public void closeIndexReader(IndexReader indexReader) {
        this.delegate.closeIndexReader(indexReader);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.delegate.getErrorHandler();
    }
}

