/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.optimization.impl;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IncrementalOptimizerStrategy
implements OptimizerStrategy {
    private static final Log log = LoggerFactory.make();
    private int operationMax = -1;
    private int transactionMax = -1;
    private long operations = 0L;
    private long transactions = 0L;
    private IndexManager indexManager;

    @Override
    public void optimizationForced() {
        this.operations = 0L;
        this.transactions = 0L;
    }

    @Override
    public boolean needOptimization() {
        return this.operationMax != -1 && this.operations >= (long)this.operationMax || this.transactionMax != -1 && this.transactions >= (long)this.transactionMax;
    }

    @Override
    public void addTransaction(long operations) {
        this.operations += operations;
        ++this.transactions;
    }

    @Override
    public void optimize(Workspace workspace) {
        if (this.needOptimization()) {
            if (log.isDebugEnabled()) {
                log.debugv("Optimize {0} after {1} operations and {2} transactions", this.indexManager.getIndexName(), this.operations, this.transactions);
            }
            IndexWriter writer = workspace.getIndexWriter();
            try {
                writer.optimize();
            }
            catch (IOException e) {
                throw new SearchException("Unable to optimize directoryProvider: " + this.indexManager.getIndexName(), e);
            }
            this.optimizationForced();
        }
    }

    @Override
    public void initialize(IndexManager indexManager, Properties indexProperties) {
        this.indexManager = indexManager;
        this.operationMax = ConfigurationParseHelper.getIntValue(indexProperties, "optimizer.operation_limit.max", -1);
        this.transactionMax = ConfigurationParseHelper.getIntValue(indexProperties, "optimizer.transaction_limit.max", -1);
    }
}

