/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Properties;
import javax.transaction.Synchronization;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.impl.WorkQueue;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.impl.HibernateHelper;
import org.hibernate.search.util.impl.WeakIdentityHashMap;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TransactionalWorker
implements Worker {
    private static final Log log = LoggerFactory.make();
    protected final WeakIdentityHashMap<Object, Synchronization> synchronizationPerTransaction = new WeakIdentityHashMap();
    private QueueingProcessor queueingProcessor;
    private SearchFactoryImplementor factory;
    private boolean transactionExpected;

    @Override
    public void performWork(Work<?> work, TransactionContext transactionContext) {
        Class<?> entityType = HibernateHelper.getClassFromWork(work);
        if (this.factory.getIndexBindingForEntity(entityType) == null && this.factory.getDocumentBuilderContainedEntity(entityType) == null) {
            throw new SearchException("Unable to perform work. Entity Class is not @Indexed nor hosts @ContainedIn: " + entityType);
        }
        if (transactionContext.isTransactionInProgress()) {
            Object transactionIdentifier = transactionContext.getTransactionIdentifier();
            PostTransactionWorkQueueSynchronization txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transactionIdentifier);
            if (txSync == null || txSync.isConsumed()) {
                txSync = new PostTransactionWorkQueueSynchronization(this.queueingProcessor, this.synchronizationPerTransaction, this.factory);
                transactionContext.registerSynchronization(txSync);
                this.synchronizationPerTransaction.put(transactionIdentifier, txSync);
            }
            txSync.add(work);
        } else {
            if (this.transactionExpected) {
                log.pushedChangesOutOfTransaction();
            }
            WorkQueue queue = new WorkQueue(this.factory);
            this.queueingProcessor.add(work, queue);
            this.queueingProcessor.prepareWorks(queue);
            this.queueingProcessor.performWorks(queue);
        }
    }

    @Override
    public void initialize(Properties props, WorkerBuildContext context, QueueingProcessor queueingProcessor) {
        this.queueingProcessor = queueingProcessor;
        this.factory = context.getUninitializedSearchFactory();
        this.transactionExpected = context.isTransactionManagerExpected();
    }

    @Override
    public void close() {
    }

    @Override
    public void flushWorks(TransactionContext transactionContext) {
        Object transaction;
        PostTransactionWorkQueueSynchronization txSync;
        if (transactionContext.isTransactionInProgress() && (txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transaction = transactionContext.getTransactionIdentifier())) != null && !txSync.isConsumed()) {
            txSync.flushWorks();
        }
    }
}

