/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class OptimizeWorkDelegate
implements LuceneWorkDelegate {
    private static final Log log = LoggerFactory.make();
    private final Workspace workspace;

    OptimizeWorkDelegate(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer) {
        Class<?> entityType = work.getEntityClass();
        log.tracef("optimize Lucene index: %s", entityType);
        try {
            writer.optimize();
            this.workspace.optimize();
        }
        catch (IOException e) {
            throw new SearchException("Unable to optimize Lucene index: " + entityType, e);
        }
    }

    @Override
    public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
    }
}

