/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.spi;

import java.io.Serializable;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.backend.spi.WorkType;

public class Work<T> {
    private final T entity;
    private final Class<T> entityClass;
    private final Serializable id;
    private final XMember idGetter;
    private final WorkType type;
    private final boolean identifierWasRolledBack;

    public Work(T entity, Serializable id, WorkType type) {
        this(entity, null, id, null, type, false);
    }

    public Work(T entity, Serializable id, WorkType type, boolean identifierRollbackEnabled) {
        this(entity, null, id, null, type, identifierRollbackEnabled);
    }

    public Work(Class<T> entityType, Serializable id, WorkType type) {
        this(null, entityType, id, null, type, false);
    }

    public Work(T entity, XMember idGetter, WorkType type) {
        this(entity, null, null, idGetter, type, false);
    }

    private Work(T entity, Class<T> entityClass, Serializable id, XMember idGetter, WorkType type, boolean identifierWasRolledBack) {
        this.entity = entity;
        this.entityClass = entityClass;
        this.id = id;
        this.idGetter = idGetter;
        this.type = type;
        this.identifierWasRolledBack = identifierWasRolledBack;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public T getEntity() {
        return this.entity;
    }

    public Serializable getId() {
        return this.id;
    }

    public XMember getIdGetter() {
        return this.idGetter;
    }

    public WorkType getType() {
        return this.type;
    }

    public boolean isIdentifierWasRolledBack() {
        return this.identifierWasRolledBack;
    }
}

