/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.BatchCoordinator;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.jmx.IndexingProgressMonitor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class MassIndexerImpl
implements MassIndexer {
    private static final Log log = LoggerFactory.make();
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final SessionFactory sessionFactory;
    protected Set<Class<?>> rootEntities = new HashSet();
    private int objectLoadingThreads = 2;
    private int collectionLoadingThreads = 4;
    private Integer writerThreads = null;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean optimizeAtEnd = true;
    private boolean purgeAtStart = true;
    private boolean optimizeAfterPurge = true;
    private MassIndexerProgressMonitor monitor;

    protected MassIndexerImpl(SearchFactoryImplementor searchFactory, SessionFactory sessionFactory, Class<?> ... entities) {
        this.searchFactoryImplementor = searchFactory;
        this.sessionFactory = sessionFactory;
        this.rootEntities = MassIndexerImpl.toRootEntities(this.searchFactoryImplementor, entities);
        this.monitor = this.searchFactoryImplementor.isJMXEnabled() ? new IndexingProgressMonitor() : new SimpleIndexingProgressMonitor();
    }

    private static Set<Class<?>> toRootEntities(SearchFactoryImplementor searchFactoryImplementor, Class<?> ... selection) {
        HashSet entities = new HashSet();
        for (Class<?> clazz : selection) {
            Set<Class<?>> targetedClasses = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{clazz});
            if (targetedClasses.isEmpty()) {
                String msg = clazz.getName() + " is not an indexed entity or a subclass of an indexed entity";
                throw new IllegalArgumentException(msg);
            }
            entities.addAll(targetedClasses);
        }
        HashSet cleaned = new HashSet();
        HashSet<Class> toRemove = new HashSet<Class>();
        for (Class clazz : entities) {
            boolean typeIsOk = true;
            for (Class clazz2 : cleaned) {
                if (clazz2.isAssignableFrom(clazz)) {
                    typeIsOk = false;
                    break;
                }
                if (!clazz.isAssignableFrom(clazz2)) continue;
                toRemove.add(clazz2);
            }
            if (!typeIsOk) continue;
            cleaned.add(clazz);
        }
        cleaned.removeAll(toRemove);
        log.debugf("Targets for indexing job: %s", cleaned);
        return cleaned;
    }

    @Override
    public MassIndexer cacheMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            throw new IllegalArgumentException("cacheMode must not be null");
        }
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.objectLoadingThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
        return this;
    }

    @Override
    public MassIndexer threadsForSubsequentFetching(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.collectionLoadingThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer threadsForIndexWriter(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.writerThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer progressMonitor(MassIndexerProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    @Override
    public MassIndexer optimizeOnFinish(boolean optimize) {
        this.optimizeAtEnd = optimize;
        return this;
    }

    @Override
    public MassIndexer optimizeAfterPurge(boolean optimize) {
        this.optimizeAfterPurge = optimize;
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.purgeAtStart = purgeAll;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> start() {
        BatchCoordinator coordinator = this.createCoordinator();
        ThreadPoolExecutor executor = Executors.newFixedThreadPool(1, "batch coordinator");
        try {
            Future<?> submit;
            Future<?> future = submit = executor.submit(coordinator);
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        coordinator.run();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected BatchCoordinator createCoordinator() {
        return new BatchCoordinator(this.rootEntities, this.searchFactoryImplementor, this.sessionFactory, this.objectLoadingThreads, this.collectionLoadingThreads, this.cacheMode, this.objectLoadingBatchSize, this.objectsLimit, this.optimizeAtEnd, this.purgeAtStart, this.optimizeAfterPurge, this.monitor, this.writerThreads);
    }

    @Override
    public MassIndexer limitIndexedObjectsTo(long maximum) {
        this.objectsLimit = maximum;
        return this;
    }
}

