/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.oracle.Encoders;
import org.geolatte.geom.codec.db.oracle.OracleJDBCTypeFactory;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

class SDOGeometryValueBinder<J>
implements ValueBinder<J> {
    private static final String SQL_TYPE_NAME = "MDSYS.SDO_GEOMETRY";
    private final OracleJDBCTypeFactory typeFactory;
    private final JavaTypeDescriptor<J> javaTypeDescriptor;

    public SDOGeometryValueBinder(JavaTypeDescriptor<J> javaTypeDescriptor, SqlTypeDescriptor sqlTypeDescriptor, OracleJDBCTypeFactory typeFactory) {
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.typeFactory = typeFactory;
    }

    public void bind(PreparedStatement st, J value, int index, WrapperOptions options) throws SQLException {
        if (value == null) {
            st.setNull(index, 2002, SQL_TYPE_NAME);
        } else {
            Geometry geometry = (Geometry)this.javaTypeDescriptor.unwrap(value, Geometry.class, options);
            Object dbGeom = this.toNative(geometry, st.getConnection());
            st.setObject(index, dbGeom);
        }
    }

    public Object store(SDOGeometry geom, Connection conn) throws SQLException {
        return this.typeFactory.createStruct(geom, conn);
    }

    private Object toNative(Geometry geom, Connection connection) {
        try {
            SDOGeometry sdoGeom = Encoders.encode((Geometry)geom);
            return this.store(sdoGeom, connection);
        }
        catch (SQLException e) {
            throw new HibernateException("Problem during conversion from JTS to SDOGeometry", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new HibernateException(e.getMessage());
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }
}

