/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.dialect.MySQL5Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.mysql.MySQLGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.mysql.MySQLSpatialDialect;
import org.hibernate.spatial.dialect.mysql.MySQLSpatialFunctions;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class MySQL56SpatialDialect
extends MySQL5Dialect
implements SpatialDialect {
    private MySQLSpatialDialect dialectDelegate = new MySQLSpatialDialect();

    public MySQL56SpatialDialect() {
        this.registerColumnType(MySQLGeometryTypeDescriptor.INSTANCE.getSqlType(), "GEOMETRY");
        MySQLSpatialFunctions functionsToRegister = this.overrideObjectShapeFunctions(new MySQLSpatialFunctions());
        for (Map.Entry<String, StandardSQLFunction> entry : functionsToRegister) {
            this.registerFunction(entry.getKey(), (SQLFunction)entry.getValue());
        }
    }

    private MySQLSpatialFunctions overrideObjectShapeFunctions(MySQLSpatialFunctions mysqlFunctions) {
        mysqlFunctions.put("contains", new StandardSQLFunction("ST_Contains", (Type)StandardBasicTypes.BOOLEAN));
        mysqlFunctions.put("crosses", new StandardSQLFunction("ST_Crosses", (Type)StandardBasicTypes.BOOLEAN));
        mysqlFunctions.put("disjoint", new StandardSQLFunction("ST_Disjoint", (Type)StandardBasicTypes.BOOLEAN));
        mysqlFunctions.put("equals", new StandardSQLFunction("ST_Equals", (Type)StandardBasicTypes.BOOLEAN));
        mysqlFunctions.put("intersects", new StandardSQLFunction("ST_Intersects", (Type)StandardBasicTypes.BOOLEAN));
        mysqlFunctions.put("overlaps", new StandardSQLFunction("ST_Overlaps", (Type)StandardBasicTypes.BOOLEAN));
        mysqlFunctions.put("touches", new StandardSQLFunction("ST_Touches", (Type)StandardBasicTypes.BOOLEAN));
        mysqlFunctions.put("within", new StandardSQLFunction("ST_Within", (Type)StandardBasicTypes.BOOLEAN));
        return mysqlFunctions;
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        return this.dialectDelegate.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        return this.dialectDelegate.getTypeName(code, length, precision, scale);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_Within(" + columnName + ",?)";
            }
            case 6: {
                return " ST_Contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_Crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_Overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_Disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_Intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_Touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_Equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return this.dialectDelegate.getSpatialFilterExpression(columnName);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        return this.dialectDelegate.getSpatialAggregateSQL(columnName, aggregation);
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return this.dialectDelegate.getDWithinSQL(columnName);
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return this.dialectDelegate.getHavingSridSQL(columnName);
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return this.dialectDelegate.getIsEmptySQL(columnName, isEmpty);
    }

    @Override
    public boolean supportsFiltering() {
        return this.dialectDelegate.supportsFiltering();
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.dialectDelegate.supports(function);
    }
}

