/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.io.Serializable;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.postgis.PGGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.postgis.PostgisFunctions;
import org.hibernate.type.BasicType;

public class PostgisSupport
implements SpatialDialect,
Serializable {
    private PostgisFunctions postgisFunctions = new PostgisFunctions();

    void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        typeContributions.contributeType((BasicType)new GeolatteGeometryType(PGGeometryTypeDescriptor.INSTANCE));
        typeContributions.contributeType((BasicType)new JTSGeometryType(PGGeometryTypeDescriptor.INSTANCE));
    }

    public PostgisFunctions functionsToRegister() {
        return this.postgisFunctions;
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_within(" + columnName + ",?)";
            }
            case 6: {
                return " ST_contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return "(" + columnName + " && ? ) ";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            case 1: {
                StringBuilder stbuf = new StringBuilder();
                stbuf.append("st_extent(").append(columnName).append(")::geometry");
                return stbuf.toString();
            }
        }
        throw new IllegalArgumentException("Aggregation of type " + aggregation + " are not supported by this dialect");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return "ST_DWithin(" + columnName + ",?,?)";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return "( ST_srid(" + columnName + ") = ?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.postgisFunctions.get(function.toString()) != null;
    }
}

