/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.h2geodb;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.hibernate.spatial.dialect.h2geodb.GeoDbWkb;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class GeoDBGeometryTypeDescriptor
implements SqlTypeDescriptor {
    public static final GeoDBGeometryTypeDescriptor INSTANCE = new GeoDBGeometryTypeDescriptor();

    public int getSqlType() {
        return 2003;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                st.setBytes(index, GeoDbWkb.to(geometry));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                st.setBytes(name, GeoDbWkb.to(geometry));
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)GeoDbWkb.from(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)GeoDbWkb.from(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)GeoDbWkb.from(statement.getObject(name)), options);
            }
        };
    }
}

