/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.HSMessageLogger;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.oracle.OracleSDOSupport;
import org.jboss.logging.Logger;

public class OracleSpatial10gDialect
extends Oracle10gDialect
implements SpatialDialect,
Serializable {
    private static final HSMessageLogger log = (HSMessageLogger)Logger.getMessageLogger(HSMessageLogger.class, (String)OracleSpatial10gDialect.class.getName());
    private transient OracleSDOSupport sdoSupport = new OracleSDOSupport(true);

    public OracleSpatial10gDialect() {
        this.registerColumnType(2002, "MDSYS.SDO_GEOMETRY");
        for (Map.Entry<String, SQLFunction> entry : this.sdoSupport.functionsToRegister()) {
            this.registerFunction(entry.getKey(), entry.getValue());
        }
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.sdoSupport.contributeTypes(typeContributions, serviceRegistry);
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return this.sdoSupport.getSpatialFilterExpression(columnName);
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        return this.sdoSupport.getSpatialRelateSQL(columnName, spatialRelation);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        return this.sdoSupport.getSpatialAggregateSQL(columnName, aggregation);
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return this.sdoSupport.getDWithinSQL(columnName);
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return this.sdoSupport.getHavingSridSQL(columnName);
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return this.sdoSupport.getIsEmptySQL(columnName, isEmpty);
    }

    @Override
    public boolean supportsFiltering() {
        return this.sdoSupport.supportsFiltering();
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }
}

