/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.jts;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class JTSUtils {
    private JTSUtils() {
    }

    public static boolean equalsExact3D(Geometry g1, Geometry g2) {
        int ng2;
        if (g1 == g2) {
            return true;
        }
        if (g1 == null || g2 == null) {
            return false;
        }
        if (!g1.getGeometryType().equals(g2.getGeometryType())) {
            return false;
        }
        if (g1.getSRID() != g2.getSRID()) {
            return false;
        }
        if (g1.isEmpty() && g2.isEmpty()) {
            return true;
        }
        int ng1 = g1.getNumGeometries();
        if (ng1 != (ng2 = g2.getNumGeometries())) {
            return false;
        }
        if (ng1 == 1) {
            return JTSUtils.equals3DPrimitiveGeometries(g1, g2);
        }
        return JTSUtils.equalComponentGeometries(g1, g2, ng1);
    }

    private static boolean equalComponentGeometries(Geometry g1, Geometry g2, int ng1) {
        for (int gIdx = 0; gIdx < ng1; ++gIdx) {
            if (JTSUtils.equalsExact3D(g1.getGeometryN(gIdx), g2.getGeometryN(gIdx))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals3D(Coordinate c1, Coordinate c2) {
        return c1.x == c2.x && c1.y == c2.y && (Double.isNaN(c1.z) && Double.isNaN(c2.z) || c1.z == c2.z) && (Double.isNaN(c1.getM()) && Double.isNaN(c2.getM()) || c1.getM() == c2.getM());
    }

    private static boolean equalLineStringCoordinates(LineString g1, LineString g2) {
        int np2;
        int np1 = g1.getNumPoints();
        if (np1 != (np2 = g2.getNumPoints())) {
            return false;
        }
        for (int i = 0; i < np1; ++i) {
            if (JTSUtils.equalsExact3D((Geometry)g1.getPointN(i), (Geometry)g2.getPointN(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalPolygonCoordinates(Polygon g1, Polygon g2) {
        int nr2;
        int nr1 = g1.getNumInteriorRing();
        if (nr1 != (nr2 = g2.getNumInteriorRing())) {
            return false;
        }
        for (int i = 0; i < nr1; ++i) {
            if (JTSUtils.equalLineStringCoordinates((LineString)g1.getInteriorRingN(i), (LineString)g2.getInteriorRingN(i))) continue;
            return false;
        }
        return JTSUtils.equalLineStringCoordinates((LineString)g1.getExteriorRing(), (LineString)g2.getExteriorRing());
    }

    private static boolean equals3DPrimitiveGeometries(Geometry g1, Geometry g2) {
        assert (g1.getClass().equals(g2.getClass()));
        if (g1 instanceof Point) {
            return JTSUtils.equals3D(g1.getCoordinate(), g2.getCoordinate());
        }
        if (g1 instanceof LineString) {
            return JTSUtils.equalLineStringCoordinates((LineString)g1, (LineString)g2);
        }
        if (g1 instanceof Polygon) {
            return JTSUtils.equalPolygonCoordinates((Polygon)g1, (Polygon)g2);
        }
        throw new IllegalStateException("Only simple geometries should be used");
    }
}

