/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.predicate;

import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.ParameterContainer;
import org.hibernate.query.criteria.internal.ParameterRegistry;
import org.hibernate.query.criteria.internal.Renderable;
import org.hibernate.query.criteria.internal.compile.RenderingContext;
import org.hibernate.query.criteria.internal.predicate.AbstractSimplePredicate;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.WithCustomJPAFilter;
import org.hibernate.spatial.jts.EnvelopeAdapter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class JTSFilterPredicate
extends AbstractSimplePredicate
implements Serializable {
    private final Expression<? extends Geometry> geometry;
    private final Expression<? extends Geometry> filter;

    public JTSFilterPredicate(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Expression<? extends Geometry> filter) {
        super((CriteriaBuilderImpl)criteriaBuilder);
        this.geometry = geometry;
        this.filter = filter;
    }

    public JTSFilterPredicate(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Geometry filter) {
        this(criteriaBuilder, geometry, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)filter));
    }

    public JTSFilterPredicate(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Envelope envelope, int srid) {
        this(criteriaBuilder, geometry, (Geometry)EnvelopeAdapter.toPolygon(envelope, srid));
    }

    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.geometry, (ParameterRegistry)registry);
        ParameterContainer.Helper.possibleParameter(this.filter, (ParameterRegistry)registry);
    }

    public String render(boolean isNegated, RenderingContext renderingContext) {
        String geometryParameter = ((Renderable)this.geometry).render(renderingContext);
        String filterParameter = ((Renderable)this.filter).render(renderingContext);
        Dialect dialect = renderingContext.getDialect();
        if (!(dialect instanceof SpatialDialect)) {
            throw new IllegalStateException("Dialect must be spatially enabled dialect");
        }
        if (dialect instanceof WithCustomJPAFilter) {
            return ((WithCustomJPAFilter)dialect).filterExpression(geometryParameter, filterParameter);
        }
        return SpatialFunction.filter.name() + "(" + geometryParameter + ", " + filterParameter + ") = true";
    }
}

