/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

class SpatialAggregate {
    private static final String SDO_AGGR = "SDO_AGGR_";
    private boolean aggregateType;
    private String aggregateSyntax;

    SpatialAggregate() {
    }

    SpatialAggregate(int aggregation) {
        String specificAggrSyntax;
        switch (aggregation) {
            case 1: {
                specificAggrSyntax = "MBR";
                this.aggregateType = false;
                break;
            }
            case 100: {
                specificAggrSyntax = "LRS_CONCAT";
                this.aggregateType = true;
                break;
            }
            case 101: {
                specificAggrSyntax = "CENTROID";
                this.aggregateType = true;
                break;
            }
            case 102: {
                specificAggrSyntax = "CONCAT_LINES";
                this.aggregateType = false;
                break;
            }
            case 103: {
                specificAggrSyntax = "UNION";
                this.aggregateType = true;
                break;
            }
            case 104: {
                specificAggrSyntax = "CONVEXHULL";
                this.aggregateType = true;
                break;
            }
            default: {
                specificAggrSyntax = null;
            }
        }
        if (specificAggrSyntax != null) {
            this.aggregateSyntax = SDO_AGGR + specificAggrSyntax;
        }
    }

    public boolean isAggregateType() {
        return this.aggregateType;
    }

    public String getAggregateSyntax() {
        return this.aggregateSyntax;
    }
}

