/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.Transaction;
import org.hibernate.cache.ReadWriteCache;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.testing.cache.Item;
import org.hibernate.testing.cache.VersionedItem;
import org.hibernate.testing.junit.functional.FunctionalTestCase;
import org.hibernate.testing.tm.ConnectionProviderImpl;
import org.hibernate.testing.tm.TransactionManagerLookupImpl;

public abstract class BaseCacheProviderTestCase
extends FunctionalTestCase {
    public BaseCacheProviderTestCase(String x) {
        super(x);
    }

    @Override
    public String getBaseForMappings() {
        return "org/hibernate/testing/";
    }

    @Override
    public String[] getMappings() {
        return new String[]{"cache/Item.hbm.xml"};
    }

    @Override
    public void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.cache.region_prefix", "");
        cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        cfg.setProperty("hibernate.generate_statistics", "true");
        cfg.setProperty("hibernate.cache.use_structured_entries", "true");
        cfg.setProperty("hibernate.cache.provider_class", this.getCacheProvider().getName());
        if (this.getConfigResourceKey() != null) {
            cfg.setProperty(this.getConfigResourceKey(), this.getConfigResourceLocation());
        }
        if (this.useTransactionManager()) {
            cfg.setProperty("hibernate.connection.provider_class", ConnectionProviderImpl.class.getName());
            cfg.setProperty("hibernate.transaction.manager_lookup_class", TransactionManagerLookupImpl.class.getName());
        } else {
            cfg.setProperty("hibernate.transaction.factory_class", JdbcTransactionFactory.class.getName());
        }
    }

    protected abstract Class getCacheProvider();

    protected abstract String getConfigResourceKey();

    protected abstract String getConfigResourceLocation();

    protected abstract boolean useTransactionManager();

    public void testQueryCacheInvalidation() {
        Session s = this.openSession();
        Transaction t = s.beginTransaction();
        Item i = new Item();
        i.setName("widget");
        i.setDescription("A really top-quality, full-featured widget.");
        s.persist((Object)i);
        t.commit();
        s.close();
        SecondLevelCacheStatistics slcs = s.getSessionFactory().getStatistics().getSecondLevelCacheStatistics(Item.class.getName());
        BaseCacheProviderTestCase.assertEquals((long)slcs.getPutCount(), (long)1L);
        BaseCacheProviderTestCase.assertEquals((long)slcs.getElementCountInMemory(), (long)1L);
        BaseCacheProviderTestCase.assertEquals((int)slcs.getEntries().size(), (int)1);
        s = this.openSession();
        t = s.beginTransaction();
        i = (Item)s.get(Item.class, (Serializable)i.getId());
        BaseCacheProviderTestCase.assertEquals((long)slcs.getHitCount(), (long)1L);
        BaseCacheProviderTestCase.assertEquals((long)slcs.getMissCount(), (long)0L);
        i.setDescription("A bog standard item");
        t.commit();
        s.close();
        BaseCacheProviderTestCase.assertEquals((long)slcs.getPutCount(), (long)2L);
        Object entry = slcs.getEntries().get(i.getId());
        Map map = entry instanceof ReadWriteCache.Item ? (Map)((ReadWriteCache.Item)entry).getValue() : (Map)entry;
        BaseCacheProviderTestCase.assertTrue((boolean)map.get("description").equals("A bog standard item"));
        BaseCacheProviderTestCase.assertTrue((boolean)map.get("name").equals("widget"));
        s = this.openSession();
        t = s.beginTransaction();
        s.delete((Object)i);
        t.commit();
        s.close();
    }

    public void testEmptySecondLevelCacheEntry() throws Exception {
        this.getSessions().evictEntity(Item.class.getName());
        Statistics stats = this.getSessions().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics statistics = stats.getSecondLevelCacheStatistics(Item.class.getName());
        Map cacheEntries = statistics.getEntries();
        BaseCacheProviderTestCase.assertEquals((int)0, (int)cacheEntries.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStaleWritesLeaveCacheConsistent() {
        Session s = this.openSession();
        Transaction txn = s.beginTransaction();
        VersionedItem item = new VersionedItem();
        item.setName("steve");
        item.setDescription("steve's item");
        s.save((Object)item);
        txn.commit();
        s.close();
        Long initialVersion = item.getVersion();
        item.setVersion(new Long(item.getVersion() - 1L));
        try {
            s = this.openSession();
            txn = s.beginTransaction();
            s.update((Object)item);
            txn.commit();
            s.close();
            BaseCacheProviderTestCase.fail((String)"expected stale write to fail");
        }
        catch (Throwable expected) {
            if (txn != null) {
                try {
                    txn.rollback();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
        }
        finally {
            if (s != null && s.isOpen()) {
                try {
                    s.close();
                }
                catch (Throwable ignore) {}
            }
        }
        SecondLevelCacheStatistics slcs = this.sfi().getStatistics().getSecondLevelCacheStatistics(VersionedItem.class.getName());
        Object entry = slcs.getEntries().get(item.getId());
        if (entry instanceof ReadWriteCache.Lock) {
            Long cachedVersionValue = new Long(((ReadWriteCache.Lock)entry).getUnlockTimestamp());
        } else {
            Long cachedVersionValue = (Long)((Map)entry).get("_version");
            BaseCacheProviderTestCase.assertEquals((long)initialVersion, (long)cachedVersionValue);
        }
        s = this.openSession();
        txn = s.beginTransaction();
        item = (VersionedItem)s.load(VersionedItem.class, (Serializable)item.getId());
        s.delete((Object)item);
        txn.commit();
        s.close();
    }
}

