/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.hibernate.AssertionFailure;
import org.hibernate.TestLogger;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.spi.ServiceRegistry;
import org.hibernate.testing.ServiceRegistryBuilder;
import org.jboss.logging.Logger;

public abstract class UnitTestCase
extends TestCase {
    private ServiceRegistry serviceRegistry;
    private Properties serviceRegistryProperties;

    public UnitTestCase(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        block8: {
            boolean doValidate = this.getName().endsWith("FailureExpected") && Boolean.getBoolean("hibernate.test.validatefailureexpected");
            try {
                ((TestLogger)Logger.getMessageLogger(TestLogger.class, (String)TestLogger.class.getName())).info((Object)("Starting test [" + this.fullTestName() + "]"));
                super.runBare();
                if (doValidate) {
                    throw new FailureExpectedTestPassedException();
                }
            }
            catch (FailureExpectedTestPassedException t) {
                throw t;
            }
            catch (Throwable t) {
                if (doValidate) {
                    this.skipExpectedFailure(t);
                    break block8;
                }
                throw t;
            }
            finally {
                TestLogger.LOG.info((Object)("Completed test [" + this.fullTestName() + "]"));
            }
        }
    }

    protected void tearDown() throws Exception {
        if (this.serviceRegistry != null) {
            ServiceRegistryBuilder.destroy(this.serviceRegistry);
            this.serviceRegistry = null;
        }
    }

    protected ServiceRegistry getServiceRegistry(Properties properties) {
        if (this.serviceRegistry == null) {
            this.serviceRegistryProperties = properties;
            this.serviceRegistry = ServiceRegistryBuilder.buildServiceRegistry(properties);
        } else if (!properties.equals(this.serviceRegistryProperties)) {
            throw new AssertionFailure("ServiceRegistry was already build using different properties.");
        }
        return this.serviceRegistry;
    }

    protected JdbcServices getJdbcServices(Properties properties) {
        return (JdbcServices)this.getServiceRegistry(properties).getService(JdbcServices.class);
    }

    protected void skipExpectedFailure(Throwable error) {
        this.reportSkip("ignoring *FailuredExpected methods", "Failed with: " + error.toString());
    }

    public static void assertElementTypeAssignability(Collection collection, Class clazz) throws AssertionFailedError {
        for (Object aCollection : collection) {
            UnitTestCase.assertClassAssignability(aCollection.getClass(), clazz);
        }
    }

    public static void assertClassAssignability(Class source, Class target) throws AssertionFailedError {
        if (!target.isAssignableFrom(source)) {
            throw new AssertionFailedError("Classes were not assignment-compatible : source<" + source.getName() + "> target<" + target.getName() + ">");
        }
    }

    public String fullTestName() {
        return ((Object)((Object)this)).getClass().getName() + "#" + this.getName();
    }

    protected void reportSkip(String reason, String testDescription) {
        TestLogger.LOG.warn((Object)("*** skipping [" + this.fullTestName() + "] - " + testDescription + " : " + reason), (Throwable)new Exception());
    }

    public static TestSuite createFailureExpectedSuite(Class testClass) {
        TestSuite allTests = new TestSuite(testClass);
        HashSet<String> failureExpected = new HashSet<String>();
        Enumeration tests = allTests.tests();
        while (tests.hasMoreElements()) {
            String name;
            Test t = (Test)tests.nextElement();
            if (!(t instanceof TestCase) || !(name = ((TestCase)t).getName()).endsWith("FailureExpected")) continue;
            failureExpected.add(name);
        }
        TestSuite result = new TestSuite();
        tests = allTests.tests();
        while (tests.hasMoreElements()) {
            String name;
            Test t = (Test)tests.nextElement();
            if (!(t instanceof TestCase) || failureExpected.contains((name = ((TestCase)t).getName()) + "FailureExpected")) continue;
            result.addTest(t);
        }
        return result;
    }

    private static class FailureExpectedTestPassedException
    extends Exception {
        public FailureExpectedTestPassedException() {
            super("Test marked as FailureExpected, but did not fail!");
        }
    }
}

