/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit.functional;

import java.util.Collections;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.hibernate.TestLogger;
import org.hibernate.testing.junit.functional.ExecutionEnvironment;
import org.hibernate.testing.junit.functional.FunctionalTestCase;

public class FunctionalTestClassTestSuite
extends TestSuite {
    private ExecutionEnvironment.Settings settings;
    private ExecutionEnvironment environment;
    private Throwable environmentSetupError;
    private int testCount;
    private int testPosition;

    public FunctionalTestClassTestSuite(Class testClass, String name) {
        super(testClass, name);
    }

    public FunctionalTestClassTestSuite(Class testClass) {
        this(testClass, testClass.getName());
    }

    public void addTest(Test test) {
        TestLogger.LOG.trace((Object)("adding test [" + test + "]"));
        if (this.settings == null && test instanceof ExecutionEnvironment.Settings) {
            this.settings = (ExecutionEnvironment.Settings)test;
        }
        ++this.testCount;
        super.addTest(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult testResult) {
        if (this.testCount == 0) {
            return;
        }
        try {
            TestLogger.LOG.info((Object)("Starting test-suite [" + this.getName() + "]"));
            this.setUp();
            this.testPosition = 0;
            super.run(testResult);
        }
        finally {
            try {
                this.tearDown();
            }
            catch (Throwable throwable) {}
            TestLogger.LOG.info((Object)("Completed test-suite [" + this.getName() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(Test test, TestResult testResult) {
        ++this.testPosition;
        if (this.environmentSetupError != null) {
            testResult.startTest(test);
            testResult.addError(test, this.environmentSetupError);
            testResult.endTest(test);
            return;
        }
        if (!(test instanceof FunctionalTestCase)) {
            super.runTest(test, testResult);
        } else {
            FunctionalTestCase functionalTest = (FunctionalTestCase)test;
            try {
                this.environment.setAllowRebuild(this.testPosition < this.testCount);
                functionalTest.setEnvironment(this.environment);
                super.runTest((Test)functionalTest, testResult);
            }
            finally {
                functionalTest.setEnvironment(null);
            }
        }
    }

    protected void setUp() {
        if (this.settings == null) {
            return;
        }
        TestLogger.LOG.info((Object)"Building aggregated execution environment");
        try {
            this.environment = new ExecutionEnvironment(this.settings);
            this.environment.initialize(this.getConnectionProviderInjectionProperties());
        }
        catch (Throwable t) {
            this.environmentSetupError = t;
        }
    }

    protected Map getConnectionProviderInjectionProperties() {
        return Collections.EMPTY_MAP;
    }

    protected void tearDown() {
        if (this.environment != null) {
            TestLogger.LOG.info((Object)"Destroying aggregated execution environment");
            this.environment.complete();
            this.environment = null;
        }
    }
}

