/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.testing.cache.BaseEntityRegionAccessStrategy;
import org.hibernate.testing.cache.EntityRegionImpl;
import org.jboss.logging.Logger;

class ReadOnlyEntityRegionAccessStrategy
extends BaseEntityRegionAccessStrategy {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)ReadOnlyEntityRegionAccessStrategy.class.getName());

    ReadOnlyEntityRegionAccessStrategy(EntityRegionImpl region) {
        super(region);
    }

    @Override
    public void remove(Object key) throws CacheException {
    }

    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        this.getInternalRegion().put(key, value);
        return true;
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        LOG.invalidEditOfReadOnlyItem(key);
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        LOG.invalidEditOfReadOnlyItem(key);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        LOG.invalidEditOfReadOnlyItem(key);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        LOG.invalidEditOfReadOnlyItem(key);
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }
}

