/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.io.Serializable;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.testing.cache.BaseRegionAccessStrategy;
import org.jboss.logging.Logger;

abstract class AbstractReadWriteAccessStrategy
extends BaseRegionAccessStrategy {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractReadWriteAccessStrategy.class.getName());
    private final UUID uuid = UUID.randomUUID();
    private final AtomicLong nextLockId = new AtomicLong();
    private ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    protected java.util.concurrent.locks.Lock readLock = this.reentrantReadWriteLock.readLock();
    protected java.util.concurrent.locks.Lock writeLock = this.reentrantReadWriteLock.writeLock();

    AbstractReadWriteAccessStrategy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object get(Object key, long txTimestamp) throws CacheException {
        LOG.debugf("getting key[%s] from region[%s]", key, (Object)this.getInternalRegion().getName());
        try {
            boolean readable;
            this.readLock.lock();
            Lockable item = (Lockable)this.getInternalRegion().get(key);
            boolean bl = readable = item != null && item.isReadable(txTimestamp);
            if (readable) {
                LOG.debugf("hit key[%s] in region[%s]", key, (Object)this.getInternalRegion().getName());
                Object object = item.getValue();
                return object;
            }
            if (item == null) {
                LOG.debugf("miss key[%s] in region[%s]", key, (Object)this.getInternalRegion().getName());
            } else {
                LOG.debugf("hit key[%s] in region[%s], but it is unreadable", key, (Object)this.getInternalRegion().getName());
            }
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            this.readLock.unlock();
        }
    }

    abstract Comparator getVersionComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        try {
            boolean writeable;
            LOG.debugf("putting key[%s] -> value[%s] into region[%s]", key, value, (Object)this.getInternalRegion().getName());
            this.writeLock.lock();
            Lockable item = (Lockable)this.getInternalRegion().get(key);
            boolean bl = writeable = item == null || item.isWriteable(txTimestamp, version, this.getVersionComparator());
            if (writeable) {
                LOG.debugf("putting key[%s] -> value[%s] into region[%s] success", key, value, (Object)this.getInternalRegion().getName());
                this.getInternalRegion().put(key, new Item(value, version, this.getInternalRegion().nextTimestamp()));
                boolean bl2 = true;
                return bl2;
            }
            LOG.debugf("putting key[%s] -> value[%s] into region[%s] fail due to it is unwriteable", key, value, (Object)this.getInternalRegion().getName());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SoftLock lockItem(Object key, Object version) throws CacheException {
        try {
            LOG.debugf("locking key[%s] in region[%s]", key, (Object)this.getInternalRegion().getName());
            this.writeLock.lock();
            Lockable item = (Lockable)this.getInternalRegion().get(key);
            long timeout = this.getInternalRegion().nextTimestamp() + (long)this.getInternalRegion().getTimeout();
            Lock lock = item == null ? new Lock(timeout, this.uuid, this.nextLockId(), version) : item.lock(timeout, this.uuid, this.nextLockId());
            this.getInternalRegion().put(key, lock);
            Lock lock2 = lock;
            return lock2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockItem(Object key, SoftLock lock) throws CacheException {
        try {
            LOG.debugf("unlocking key[%s] in region[%s]", key, (Object)this.getInternalRegion().getName());
            this.writeLock.lock();
            Lockable item = (Lockable)this.getInternalRegion().get(key);
            if (item != null && item.isUnlockable(lock)) {
                this.decrementLock(key, (Lock)item);
            } else {
                this.handleLockExpiry(key, item);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private long nextLockId() {
        return this.nextLockId.getAndIncrement();
    }

    protected void decrementLock(Object key, Lock lock) {
        lock.unlock(this.getInternalRegion().nextTimestamp());
        this.getInternalRegion().put(key, lock);
    }

    protected void handleLockExpiry(Object key, Lockable lock) {
        LOG.expired(key);
        long ts = this.getInternalRegion().nextTimestamp() + (long)this.getInternalRegion().getTimeout();
        Lock newLock = new Lock(ts, this.uuid, this.nextLockId.getAndIncrement(), null);
        newLock.unlock(ts);
        this.getInternalRegion().put(key, newLock);
    }

    protected static final class Lock
    implements Serializable,
    Lockable,
    SoftLock {
        private static final long serialVersionUID = 2L;
        private final UUID sourceUuid;
        private final long lockId;
        private final Object version;
        private long timeout;
        private boolean concurrent;
        private int multiplicity = 1;
        private long unlockTimestamp;

        Lock(long timeout, UUID sourceUuid, long lockId, Object version) {
            this.timeout = timeout;
            this.lockId = lockId;
            this.version = version;
            this.sourceUuid = sourceUuid;
        }

        @Override
        public boolean isReadable(long txTimestamp) {
            return false;
        }

        @Override
        public boolean isWriteable(long txTimestamp, Object newVersion, Comparator versionComparator) {
            if (txTimestamp > this.timeout) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? txTimestamp > this.unlockTimestamp : versionComparator.compare(this.version, newVersion) < 0;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public boolean isUnlockable(SoftLock lock) {
            return this.equals(lock);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Lock) {
                return this.lockId == ((Lock)o).lockId && this.sourceUuid.equals(((Lock)o).sourceUuid);
            }
            return false;
        }

        public int hashCode() {
            int hash = this.sourceUuid != null ? this.sourceUuid.hashCode() : 0;
            int temp = (int)this.lockId;
            for (int i = 1; i < 2; ++i) {
                temp = (int)((long)temp ^ this.lockId >>> i * 32);
            }
            return hash + temp;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrent;
        }

        @Override
        public Lock lock(long timeout, UUID uuid, long lockId) {
            this.concurrent = true;
            ++this.multiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long timestamp) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = timestamp;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Lock Source-UUID:" + this.sourceUuid + " Lock-ID:" + this.lockId);
            return sb.toString();
        }
    }

    protected static final class Item
    implements Serializable,
    Lockable {
        private static final long serialVersionUID = 1L;
        private final Object value;
        private final Object version;
        private final long timestamp;

        Item(Object value, Object version, long timestamp) {
            this.value = value;
            this.version = version;
            this.timestamp = timestamp;
        }

        @Override
        public boolean isReadable(long txTimestamp) {
            return txTimestamp > this.timestamp;
        }

        @Override
        public boolean isWriteable(long txTimestamp, Object newVersion, Comparator versionComparator) {
            return this.version != null && versionComparator.compare(this.version, newVersion) < 0;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isUnlockable(SoftLock lock) {
            return false;
        }

        @Override
        public Lock lock(long timeout, UUID uuid, long lockId) {
            return new Lock(timeout, uuid, lockId, this.version);
        }
    }

    protected static interface Lockable {
        public boolean isReadable(long var1);

        public boolean isWriteable(long var1, Object var3, Comparator var4);

        public Object getValue();

        public boolean isUnlockable(SoftLock var1);

        public Lock lock(long var1, UUID var3, long var4);
    }
}

