/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.testing.cache.BaseTransactionalDataRegion;
import org.hibernate.testing.cache.NonstrictReadWriteEntityRegionAccessStrategy;
import org.hibernate.testing.cache.ReadOnlyEntityRegionAccessStrategy;
import org.hibernate.testing.cache.ReadWriteEntityRegionAccessStrategy;
import org.hibernate.testing.cache.TransactionalEntityRegionAccessStrategy;
import org.jboss.logging.Logger;

class EntityRegionImpl
extends BaseTransactionalDataRegion
implements EntityRegion {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityRegionImpl.class.getName());
    private final Settings settings;

    EntityRegionImpl(String name, CacheDataDescription metadata, Settings settings) {
        super(name, metadata);
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        switch (accessType) {
            case READ_ONLY: {
                if (this.getCacheDataDescription().isMutable()) {
                    LOG.warnf("read-only cache configured for mutable entity [ %s ]", (Object)this.getName());
                }
                return new ReadOnlyEntityRegionAccessStrategy(this);
            }
            case READ_WRITE: {
                return new ReadWriteEntityRegionAccessStrategy(this);
            }
            case NONSTRICT_READ_WRITE: {
                return new NonstrictReadWriteEntityRegionAccessStrategy(this);
            }
            case TRANSACTIONAL: {
                return new TransactionalEntityRegionAccessStrategy(this);
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }
}

