/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Mappings;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.OnExpectedFailure;
import org.hibernate.testing.OnFailure;
import org.hibernate.testing.SkipLog;
import org.hibernate.testing.cache.CachingRegionFactory;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.hibernate.testing.junit4.Helper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseCoreFunctionalTestCase
extends BaseUnitTestCase {
    public static final String VALIDATE_DATA_CLEANUP = "hibernate.test.validateDataCleanup";
    public static final String USE_NEW_METADATA_MAPPINGS = "hibernate.test.new_metadata_mappings";
    public static final Dialect DIALECT = Dialect.getDialect();
    private boolean isMetadataUsed;
    private Configuration configuration;
    private StandardServiceRegistryImpl serviceRegistry;
    private SessionFactoryImplementor sessionFactory;
    protected Session session;
    protected static final String[] NO_MAPPINGS = new String[0];
    protected static final Class<?>[] NO_CLASSES = new Class[0];

    protected static Dialect getDialect() {
        return DIALECT;
    }

    protected Configuration configuration() {
        return this.configuration;
    }

    protected StandardServiceRegistryImpl serviceRegistry() {
        return this.serviceRegistry;
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    protected Session openSession() throws HibernateException {
        this.session = this.sessionFactory().openSession();
        return this.session;
    }

    protected Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.sessionFactory().withOptions().interceptor(interceptor).openSession();
        return this.session;
    }

    @BeforeClassOnce
    protected void buildSessionFactory() {
        this.configuration = this.constructAndConfigureConfiguration();
        BootstrapServiceRegistry bootRegistry = this.buildBootstrapServiceRegistry();
        this.serviceRegistry = this.buildServiceRegistry(bootRegistry, this.configuration);
        this.isMetadataUsed = (Boolean)((ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class)).getSetting(USE_NEW_METADATA_MAPPINGS, (ConfigurationService.Converter)new ConfigurationService.Converter<Boolean>(){

            public Boolean convert(Object value) {
                return Boolean.parseBoolean((String)value);
            }
        }, (Object)false);
        if (this.isMetadataUsed) {
            MetadataImplementor metadataImplementor = this.buildMetadata(bootRegistry, this.serviceRegistry);
            this.afterConstructAndConfigureMetadata(metadataImplementor);
            this.sessionFactory = (SessionFactoryImplementor)metadataImplementor.buildSessionFactory();
        } else {
            this.afterConstructAndConfigureConfiguration(this.configuration);
            this.sessionFactory = (SessionFactoryImplementor)this.configuration.buildSessionFactory((ServiceRegistry)this.serviceRegistry);
        }
        this.afterSessionFactoryBuilt();
    }

    protected void rebuildSessionFactory() {
        if (this.sessionFactory == null) {
            return;
        }
        try {
            this.sessionFactory.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.buildSessionFactory();
    }

    protected void afterConstructAndConfigureMetadata(MetadataImplementor metadataImplementor) {
    }

    private MetadataImplementor buildMetadata(BootstrapServiceRegistry bootRegistry, StandardServiceRegistryImpl serviceRegistry) {
        MetadataSources sources = new MetadataSources((ServiceRegistry)bootRegistry);
        this.addMappings(sources);
        return (MetadataImplementor)sources.getMetadataBuilder((StandardServiceRegistry)serviceRegistry).build();
    }

    protected Configuration buildConfiguration() {
        Configuration cfg = this.constructAndConfigureConfiguration();
        this.afterConstructAndConfigureConfiguration(cfg);
        return cfg;
    }

    private Configuration constructAndConfigureConfiguration() {
        Configuration cfg = this.constructConfiguration();
        this.configure(cfg);
        return cfg;
    }

    private void afterConstructAndConfigureConfiguration(Configuration cfg) {
        this.addMappings(cfg);
        cfg.buildMappings();
        this.applyCacheSettings(cfg);
        this.afterConfigurationBuilt(cfg);
    }

    protected Configuration constructConfiguration() {
        Configuration configuration = new Configuration().setProperty("hibernate.cache.region.factory_class", CachingRegionFactory.class.getName());
        configuration.setProperty("hibernate.id.new_generator_mappings", "true");
        if (this.createSchema()) {
            configuration.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            String secondSchemaName = this.createSecondSchema();
            if (StringHelper.isNotEmpty((String)secondSchemaName)) {
                if (!(BaseCoreFunctionalTestCase.getDialect() instanceof H2Dialect)) {
                    throw new UnsupportedOperationException("Only H2 dialect supports creation of second schema.");
                }
                Helper.createH2Schema(secondSchemaName, configuration);
            }
        }
        configuration.setProperty("hibernate.dialect", BaseCoreFunctionalTestCase.getDialect().getClass().getName());
        return configuration;
    }

    protected void configure(Configuration configuration) {
    }

    protected void addMappings(Configuration configuration) {
        String[] xmlFiles;
        String[] annotatedPackages;
        Class<?>[] annotatedClasses;
        String[] mappings = this.getMappings();
        if (mappings != null) {
            for (String mapping : mappings) {
                configuration.addResource(this.getBaseForMappings() + mapping, this.getClass().getClassLoader());
            }
        }
        if ((annotatedClasses = this.getAnnotatedClasses()) != null) {
            for (Class<?> annotatedClass : annotatedClasses) {
                configuration.addAnnotatedClass(annotatedClass);
            }
        }
        if ((annotatedPackages = this.getAnnotatedPackages()) != null) {
            for (String annotatedPackage : annotatedPackages) {
                configuration.addPackage(annotatedPackage);
            }
        }
        if ((xmlFiles = this.getXmlFiles()) != null) {
            for (String xmlFile : xmlFiles) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                configuration.addInputStream(is);
            }
        }
    }

    protected void addMappings(MetadataSources sources) {
        String[] xmlFiles;
        String[] annotatedPackages;
        Class<?>[] annotatedClasses;
        String[] mappings = this.getMappings();
        if (mappings != null) {
            for (String mapping : mappings) {
                sources.addResource(this.getBaseForMappings() + mapping);
            }
        }
        if ((annotatedClasses = this.getAnnotatedClasses()) != null) {
            for (Class<?> annotatedClass : annotatedClasses) {
                sources.addAnnotatedClass(annotatedClass);
            }
        }
        if ((annotatedPackages = this.getAnnotatedPackages()) != null) {
            for (String annotatedPackage : annotatedPackages) {
                sources.addPackage(annotatedPackage);
            }
        }
        if ((xmlFiles = this.getXmlFiles()) != null) {
            for (String xmlFile : xmlFiles) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                sources.addInputStream(is);
            }
        }
    }

    protected String[] getMappings() {
        return NO_MAPPINGS;
    }

    protected String getBaseForMappings() {
        return "org/hibernate/test/";
    }

    protected Class<?>[] getAnnotatedClasses() {
        return NO_CLASSES;
    }

    protected String[] getAnnotatedPackages() {
        return NO_MAPPINGS;
    }

    protected String[] getXmlFiles() {
        return NO_MAPPINGS;
    }

    protected void applyCacheSettings(Configuration configuration) {
        if (this.getCacheConcurrencyStrategy() != null) {
            Iterator itr = configuration.getClassMappings();
            while (itr.hasNext()) {
                PersistentClass clazz = (PersistentClass)itr.next();
                Iterator props = clazz.getPropertyClosureIterator();
                boolean hasLob = false;
                while (props.hasNext()) {
                    Property prop = (Property)props.next();
                    if (!prop.getValue().isSimpleValue()) continue;
                    String type = ((SimpleValue)prop.getValue()).getTypeName();
                    if ("blob".equals(type) || "clob".equals(type)) {
                        hasLob = true;
                    }
                    if (!Blob.class.getName().equals(type) && !Clob.class.getName().equals(type)) continue;
                    hasLob = true;
                }
                if (hasLob || clazz.isInherited() || !this.overrideCacheStrategy()) continue;
                configuration.setCacheConcurrencyStrategy(clazz.getEntityName(), this.getCacheConcurrencyStrategy());
            }
            itr = configuration.getCollectionMappings();
            while (itr.hasNext()) {
                Collection coll = (Collection)itr.next();
                configuration.setCollectionCacheConcurrencyStrategy(coll.getRole(), this.getCacheConcurrencyStrategy());
            }
        }
    }

    protected boolean overrideCacheStrategy() {
        return true;
    }

    protected String getCacheConcurrencyStrategy() {
        return null;
    }

    protected void afterConfigurationBuilt(Configuration configuration) {
        this.afterConfigurationBuilt(configuration.createMappings(), BaseCoreFunctionalTestCase.getDialect());
    }

    protected void afterConfigurationBuilt(Mappings mappings, Dialect dialect) {
    }

    protected BootstrapServiceRegistry buildBootstrapServiceRegistry() {
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        this.prepareBootstrapRegistryBuilder(builder);
        return builder.build();
    }

    protected void prepareBootstrapRegistryBuilder(BootstrapServiceRegistryBuilder builder) {
    }

    protected StandardServiceRegistryImpl buildServiceRegistry(BootstrapServiceRegistry bootRegistry, Configuration configuration) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)configuration.getProperties());
        Environment.verifyProperties((Map)properties);
        ConfigurationHelper.resolvePlaceHolders((Map)properties);
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder(bootRegistry).applySettings((Map)properties);
        this.prepareBasicRegistryBuilder(registryBuilder);
        return (StandardServiceRegistryImpl)registryBuilder.build();
    }

    protected void prepareBasicRegistryBuilder(StandardServiceRegistryBuilder serviceRegistryBuilder) {
    }

    protected void afterSessionFactoryBuilt() {
    }

    protected boolean createSchema() {
        return true;
    }

    protected String createSecondSchema() {
        return null;
    }

    protected boolean rebuildSessionFactoryOnError() {
        return true;
    }

    @AfterClassOnce
    protected void releaseSessionFactory() {
        if (this.sessionFactory == null) {
            return;
        }
        this.sessionFactory.close();
        this.sessionFactory = null;
        this.configuration = null;
        if (this.serviceRegistry == null) {
            return;
        }
        this.serviceRegistry.destroy();
        this.serviceRegistry = null;
    }

    @OnFailure
    @OnExpectedFailure
    public void onFailure() {
        if (this.rebuildSessionFactoryOnError()) {
            this.rebuildSessionFactory();
        }
    }

    @Before
    public final void beforeTest() throws Exception {
        this.prepareTest();
    }

    protected void prepareTest() throws Exception {
    }

    @After
    public final void afterTest() throws Exception {
        if (this.isCleanupTestDataRequired()) {
            this.cleanupTestData();
        }
        this.cleanupTest();
        this.cleanupSession();
        this.assertAllDataRemoved();
    }

    protected void cleanupCache() {
        if (this.sessionFactory != null) {
            this.sessionFactory.getCache().evictAllRegions();
        }
    }

    protected boolean isCleanupTestDataRequired() {
        return false;
    }

    protected void cleanupTestData() throws Exception {
        Session s = this.openSession();
        s.beginTransaction();
        s.createQuery("delete from java.lang.Object").executeUpdate();
        s.getTransaction().commit();
        s.close();
    }

    private void cleanupSession() {
        if (this.session != null && !((SessionImplementor)this.session).isClosed()) {
            if (this.session.isConnected()) {
                this.session.doWork((Work)new RollbackWork());
            }
            this.session.close();
        }
        this.session = null;
    }

    protected void cleanupTest() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertAllDataRemoved() {
        if (!this.createSchema()) {
            return;
        }
        if (!Boolean.getBoolean(VALIDATE_DATA_CLEANUP)) {
            return;
        }
        Session tmpSession = this.sessionFactory.openSession();
        try {
            List list = tmpSession.createQuery("select o from java.lang.Object o").list();
            HashMap<String, Integer> items = new HashMap<String, Integer>();
            if (!list.isEmpty()) {
                for (Object element : list) {
                    Integer l = (Integer)items.get(tmpSession.getEntityName(element));
                    if (l == null) {
                        l = 0;
                    }
                    l = l + 1;
                    items.put(tmpSession.getEntityName(element), l);
                    System.out.println("Data left: " + element);
                }
                Assert.fail((String)("Data is left in the database: " + ((Object)items).toString()));
            }
        }
        finally {
            try {
                tmpSession.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readCommittedIsolationMaintained(String scenario) {
        int isolation = 1;
        Session testSession = null;
        try {
            testSession = this.openSession();
            isolation = (Integer)testSession.doReturningWork((ReturningWork)new AbstractReturningWork<Integer>(){

                public Integer execute(Connection connection) throws SQLException {
                    return connection.getTransactionIsolation();
                }
            });
        }
        catch (Throwable ignore) {
        }
        finally {
            if (testSession != null) {
                try {
                    testSession.close();
                }
                catch (Throwable ignore) {}
            }
        }
        if (isolation < 2) {
            SkipLog.reportSkip("environment does not support at least read committed isolation", scenario);
            return false;
        }
        return true;
    }

    public class RollbackWork
    implements Work {
        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }
}

