/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.hibernate.testing.junit4.AfterClassCallbackHandler;
import org.hibernate.testing.junit4.BeforeClassCallbackHandler;
import org.hibernate.testing.junit4.CustomRunner;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class CustomParameterized
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final ArrayList<Runner> runners = new ArrayList();

    public CustomParameterized(Class<?> klass) throws Throwable {
        super(klass, NO_RUNNERS);
        List<FrameworkMethod> parametersMethods = this.getParametersMethods();
        this.createRunnersForParameters(this.allParameters(parametersMethods), this.concatNames(parametersMethods));
    }

    private String concatNames(List<FrameworkMethod> parametersMethods) {
        StringBuilder sb = new StringBuilder();
        for (FrameworkMethod method : parametersMethods) {
            Parameterized.Parameters parameters = (Parameterized.Parameters)method.getAnnotation(Parameterized.Parameters.class);
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(parameters.name());
        }
        return sb.toString();
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private Iterable<Object[]> allParameters(List<FrameworkMethod> parametersMethods) throws Throwable {
        ArrayList<Iterable> returnedParameters = new ArrayList<Iterable>();
        ArrayList<Object[]> allParameters = new ArrayList<Object[]>();
        Object cachedInstance = null;
        for (FrameworkMethod method : parametersMethods) {
            Iterator parameters;
            if (method.isStatic()) {
                parameters = method.invokeExplosively(null, new Object[0]);
            } else {
                if (cachedInstance == null) {
                    cachedInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
                }
                parameters = method.invokeExplosively(cachedInstance, new Object[0]);
            }
            if (parameters instanceof Iterable) {
                returnedParameters.add((Iterable)((Object)parameters));
                continue;
            }
            throw this.parametersMethodReturnedWrongType(method);
        }
        for (Iterable parameters : returnedParameters) {
            if (allParameters.isEmpty()) {
                for (Object[] array : parameters) {
                    allParameters.add(array);
                }
                continue;
            }
            ArrayList<Object[]> newAllParameters = new ArrayList<Object[]>();
            for (Object[] prev : allParameters) {
                for (Object[] array : parameters) {
                    Object[] next = Arrays.copyOf(prev, prev.length + array.length);
                    System.arraycopy(array, 0, next, prev.length, array.length);
                    newAllParameters.add(next);
                }
            }
            allParameters = newAllParameters;
        }
        return allParameters;
    }

    private List<FrameworkMethod> getParametersMethods() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameterized.Parameters.class);
        TreeMap<Integer, FrameworkMethod> sortedMethods = new TreeMap<Integer, FrameworkMethod>();
        for (FrameworkMethod each : methods) {
            if (each.isPublic()) {
                if (!each.isStatic() && this.getTestClass().getOnlyConstructor().getParameterTypes().length != 0) {
                    throw new Exception("Method " + each.getMethod() + " is annotated with @Parameters, it is not static and there is no parameter-less constructor!");
                }
                Order order = (Order)each.getAnnotation(Order.class);
                int value = order == null ? 0 : order.value();
                FrameworkMethod prev = sortedMethods.put(value, each);
                if (prev == null) continue;
                throw new Exception(String.format("There are more methods annotated with @Parameters and @Order(value=%d): %s (%s) and %s (%s)", value, prev.getMethod(), prev.getAnnotation(Order.class), each.getMethod(), order));
            }
            throw new Exception("Method " + each.getMethod() + " is annotated with @Parameters but it is not public!");
        }
        if (sortedMethods.isEmpty()) {
            throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
        }
        return new ArrayList<FrameworkMethod>(sortedMethods.values());
    }

    private void createRunnersForParameters(Iterable<Object[]> allParameters, String namePattern) throws Exception {
        int i = 0;
        for (Object[] parametersOfSingleTest : allParameters) {
            String name = this.nameFor(namePattern, i, parametersOfSingleTest);
            CustomRunnerForParameters runner = new CustomRunnerForParameters(this.getTestClass().getJavaClass(), parametersOfSingleTest, name);
            this.runners.add((Runner)runner);
            ++i;
        }
    }

    private String nameFor(String namePattern, int index, Object[] parameters) {
        String finalPattern = namePattern.replaceAll("\\{index\\}", Integer.toString(index));
        String name = MessageFormat.format(finalPattern, parameters);
        return "[" + name + "]";
    }

    private Exception parametersMethodReturnedWrongType(FrameworkMethod method) throws Exception {
        String className = this.getTestClass().getName();
        String methodName = method.getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new Exception(message);
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameterized.Parameter.class);
    }

    private boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Order {
        public int value();
    }

    private class CustomRunnerForParameters
    extends CustomRunner {
        private final Object[] parameters;
        private final String name;

        CustomRunnerForParameters(Class<?> type, Object[] parameters, String name) throws InitializationError, NoTestsRemainException {
            super(type);
            this.parameters = parameters;
            this.name = name;
        }

        @Override
        protected Object getTestInstance() throws Exception {
            if (this.testInstance == null) {
                this.testInstance = CustomParameterized.this.fieldsAreAnnotated() ? this.createTestUsingFieldInjection() : this.createTestUsingConstructorInjection();
            }
            return this.testInstance;
        }

        private Object createTestUsingConstructorInjection() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.parameters);
        }

        private Object createTestUsingFieldInjection() throws Exception {
            List annotatedFieldsByParameter = CustomParameterized.this.getAnnotatedFieldsByParameter();
            if (annotatedFieldsByParameter.size() != this.parameters.length) {
                throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + this.parameters.length + ".");
            }
            Object testClassInstance = this.getTestClass().getJavaClass().newInstance();
            for (FrameworkField each : annotatedFieldsByParameter) {
                Field field = each.getField();
                Parameterized.Parameter annotation = field.getAnnotation(Parameterized.Parameter.class);
                int index = annotation.value();
                try {
                    field.set(testClassInstance, this.parameters[index]);
                }
                catch (IllegalArgumentException iare) {
                    throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + this.parameters[index] + " that is not the right type (" + this.parameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
                }
            }
            return testClassInstance;
        }

        protected String getName() {
            return this.name;
        }

        protected String testName(FrameworkMethod method) {
            return method.getName() + this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
            if (CustomParameterized.this.fieldsAreAnnotated()) {
                this.validateZeroArgConstructor(errors);
            }
        }

        protected void validateFields(List<Throwable> errors) {
            super.validateFields(errors);
            if (CustomParameterized.this.fieldsAreAnnotated()) {
                List annotatedFieldsByParameter = CustomParameterized.this.getAnnotatedFieldsByParameter();
                int[] usedIndices = new int[annotatedFieldsByParameter.size()];
                for (FrameworkField each : annotatedFieldsByParameter) {
                    int index = each.getField().getAnnotation(Parameterized.Parameter.class).value();
                    if (index < 0 || index > annotatedFieldsByParameter.size() - 1) {
                        errors.add(new Exception("Invalid @Parameter value: " + index + ". @Parameter fields counted: " + annotatedFieldsByParameter.size() + ". Please use an index between 0 and " + (annotatedFieldsByParameter.size() - 1) + "."));
                        continue;
                    }
                    int n = index;
                    usedIndices[n] = usedIndices[n] + 1;
                }
                for (int index = 0; index < usedIndices.length; ++index) {
                    int numberOfUse = usedIndices[index];
                    if (numberOfUse == 0) {
                        errors.add(new Exception("@Parameter(" + index + ") is never used."));
                        continue;
                    }
                    if (numberOfUse <= 1) continue;
                    errors.add(new Exception("@Parameter(" + index + ") is used more than once (" + numberOfUse + ")."));
                }
            }
        }

        @Override
        protected Statement classBlock(RunNotifier notifier) {
            Statement statement = this.childrenInvoker(notifier);
            statement = this.withBeforeClasses(statement);
            statement = this.withAfterClasses(statement);
            return statement;
        }

        @Override
        protected Statement withBeforeClasses(Statement statement) {
            if (this.isAllTestsIgnored()) {
                return statement;
            }
            return new BeforeClassCallbackHandler(this, statement);
        }

        @Override
        protected Statement withAfterClasses(Statement statement) {
            if (this.isAllTestsIgnored()) {
                return statement;
            }
            return new AfterClassCallbackHandler(this, statement);
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }
    }
}

