/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.env;

import java.util.Map;
import java.util.Properties;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.testing.DialectCheck;
import org.hibernate.testing.env.TestingDatabaseInfo;

public class ConnectionProviderBuilder
implements DialectCheck {
    public static final String DRIVER = "org.h2.Driver";
    public static final String URL = "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1";
    public static final String USER = "sa";
    public static final String PASS = "";

    public static Properties getConnectionProviderProperties(String dbName) {
        Properties props = new Properties(null);
        props.put("hibernate.connection.driver_class", DRIVER);
        props.put("hibernate.connection.url", String.format(URL, dbName));
        props.put("hibernate.connection.username", USER);
        props.put("hibernate.connection.password", PASS);
        return props;
    }

    public static Properties getConnectionProviderProperties() {
        return ConnectionProviderBuilder.getConnectionProviderProperties("db1");
    }

    public static DriverManagerConnectionProviderImpl buildConnectionProvider() {
        return ConnectionProviderBuilder.buildConnectionProvider(false);
    }

    public static DriverManagerConnectionProviderImpl buildConnectionProvider(String dbName) {
        return ConnectionProviderBuilder.buildConnectionProvider(ConnectionProviderBuilder.getConnectionProviderProperties(dbName), false);
    }

    public static DriverManagerConnectionProviderImpl buildConnectionProvider(boolean allowAggressiveRelease) {
        return ConnectionProviderBuilder.buildConnectionProvider(ConnectionProviderBuilder.getConnectionProviderProperties("db1"), allowAggressiveRelease);
    }

    private static DriverManagerConnectionProviderImpl buildConnectionProvider(Properties props, final boolean allowAggressiveRelease) {
        DriverManagerConnectionProviderImpl connectionProvider = new DriverManagerConnectionProviderImpl(){

            public boolean supportsAggressiveRelease() {
                return allowAggressiveRelease;
            }
        };
        connectionProvider.configure((Map)props);
        return connectionProvider;
    }

    public static Dialect getCorrespondingDialect() {
        return TestingDatabaseInfo.DIALECT;
    }

    @Override
    public boolean isMatch(Dialect dialect) {
        return ConnectionProviderBuilder.getCorrespondingDialect().getClass().equals(dialect.getClass());
    }
}

