/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.util;

import javax.persistence.LockTimeoutException;
import org.hibernate.PessimisticLockException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;

public class ExceptionUtil {
    private static final ExceptionUtil INSTANCE = new ExceptionUtil();

    public static ExceptionUtil getInstance() {
        return INSTANCE;
    }

    private ExceptionUtil() {
    }

    public static Throwable rootCause(Throwable t) {
        Throwable cause = t.getCause();
        if (cause != null && cause != t) {
            return ExceptionUtil.rootCause(cause);
        }
        return t;
    }

    public static Throwable findCause(Throwable t, Class<? extends Throwable> causeClass) {
        Throwable cause = t.getCause();
        if (cause != null && !causeClass.equals(cause.getClass())) {
            return cause != t ? ExceptionUtil.findCause(cause, causeClass) : null;
        }
        return cause;
    }

    public static boolean isSqlLockTimeout(Exception e) {
        if (LockAcquisitionException.class.isInstance(e) || LockTimeoutException.class.isInstance(e) || GenericJDBCException.class.isInstance(e) || PessimisticLockException.class.isInstance(e) || javax.persistence.PessimisticLockException.class.isInstance(e) || JDBCConnectionException.class.isInstance(e)) {
            return true;
        }
        Throwable rootCause = ExceptionUtil.rootCause(e);
        return rootCause != null && (rootCause.getMessage().contains("timeout") || rootCause.getMessage().contains("timed out"));
    }

    public static boolean isConnectionClose(Exception e) {
        Throwable rootCause = ExceptionUtil.rootCause(e);
        return rootCause != null && (rootCause.getMessage().toLowerCase().contains("connection is close") || rootCause.getMessage().toLowerCase().contains("closed connection"));
    }
}

