/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.BaseRegionAccessStrategy;
import org.hibernate.testing.cache.NaturalIdRegionImpl;

class BaseNaturalIdRegionAccessStrategy
extends BaseRegionAccessStrategy
implements NaturalIdRegionAccessStrategy {
    private final NaturalIdRegionImpl region;

    @Override
    protected BaseGeneralDataRegion getInternalRegion() {
        return this.region;
    }

    @Override
    protected boolean isDefaultMinimalPutOverride() {
        return this.region.getSettings().isMinimalPutsEnabled();
    }

    public NaturalIdRegion getRegion() {
        return this.region;
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return this.putFromLoad(session, key, value, 0L, null);
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return this.putFromLoad(session, key, value, 0L, null);
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        return false;
    }

    BaseNaturalIdRegionAccessStrategy(NaturalIdRegionImpl region) {
        this.region = region;
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return this.region.getRegionFactory().getCacheKeysFactory().createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return this.region.getRegionFactory().getCacheKeysFactory().getNaturalIdValues(cacheKey);
    }
}

