/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.testing.cache.DomainDataRegionImpl;
import org.hibernate.testing.cache.MapStorageAccessImpl;
import org.jboss.logging.Logger;

public class CachingRegionFactory
extends RegionFactoryTemplate {
    private static final Logger LOG = Logger.getLogger((String)CachingRegionFactory.class.getName());
    public static String DEFAULT_ACCESSTYPE = "DefaultAccessType";
    private final CacheKeysFactory cacheKeysFactory;

    public CachingRegionFactory() {
        this((CacheKeysFactory)DefaultCacheKeysFactory.INSTANCE, null);
    }

    public CachingRegionFactory(CacheKeysFactory cacheKeysFactory) {
        this(cacheKeysFactory, null);
    }

    public CachingRegionFactory(Properties properties) {
        this((CacheKeysFactory)DefaultCacheKeysFactory.INSTANCE, properties);
    }

    public CachingRegionFactory(CacheKeysFactory cacheKeysFactory, Properties properties) {
        LOG.warn((Object)"org.hibernate.testing.cache.CachingRegionFactory should be only used for testing.");
        this.cacheKeysFactory = cacheKeysFactory;
    }

    protected void prepareForUse(SessionFactoryOptions settings, Map configValues) {
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new DomainDataRegionImpl(regionConfig, this, this.cacheKeysFactory, buildingContext);
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new MapStorageAccessImpl();
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        return new MapStorageAccessImpl();
    }

    protected void releaseFromUse() {
    }
}

