/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.lang.reflect.Field;
import org.hibernate.AssertionFailure;
import org.hibernate.testing.logger.Log4J2DelegatingLogger;
import org.hibernate.testing.logger.LogListener;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;

final class LogInspectionHelper {
    private LogInspectionHelper() {
    }

    static void registerListener(LogListener listener, BasicLogger log) {
        LogInspectionHelper.convertType(log).registerListener(listener);
    }

    static void clearAllListeners(BasicLogger log) {
        LogInspectionHelper.convertType(log).clearAllListeners();
    }

    private static Log4J2DelegatingLogger convertType(BasicLogger log) {
        if (log instanceof DelegatingBasicLogger) {
            DelegatingBasicLogger wrapper = (DelegatingBasicLogger)log;
            try {
                return LogInspectionHelper.extractFromWrapper(wrapper);
            }
            catch (Exception cause) {
                throw new RuntimeException(cause);
            }
        }
        if (!(log instanceof Log4J2DelegatingLogger)) {
            throw new AssertionFailure("Unexpected log type: JBoss Logger didn't register the custom TestableLoggerProvider as logger provider");
        }
        return (Log4J2DelegatingLogger)log;
    }

    private static Log4J2DelegatingLogger extractFromWrapper(DelegatingBasicLogger wrapper) throws Exception {
        Field field = DelegatingBasicLogger.class.getDeclaredField("log");
        field.setAccessible(true);
        Object object = field.get(wrapper);
        return LogInspectionHelper.convertType((BasicLogger)object);
    }
}

